/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.CrowdTestRule;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.UserListChangedEvent;
import com.atlassian.fisheye.functest.util.DisableUpdatingGroupsRule;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.user.Auth;
import com.cenqua.fisheye.user.AuthenticationFactory;
import com.cenqua.fisheye.user.DefaultGroupMembershipManager;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hibernate.SessionFactory;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration
@ContextConfiguration(value={"classpath:/tests-db-spring-context-crowd.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class DefaultGroupMembershipManagerTest {
    @Autowired
    private CrowdService crowdService;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    @Rule
    public CrowdTestRule crowdTestRule;
    @Autowired
    @Rule
    public DisableUpdatingGroupsRule disableUpdatingGroupsRule;
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    private final Auth mockAuth = (Auth)Mockito.mock(Auth.class);
    private final AuthenticationFactory mockAuthenticationFactory = (AuthenticationFactory)Mockito.mock(AuthenticationFactory.class);
    private DefaultGroupMembershipManager groupMembershipManager;
    private EventPublisher eventPublisher;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.mockAuthenticationFactory.getAuth((SecurityType)org.mockito.Matchers.any(SecurityType.class))).thenReturn((Object)this.mockAuth);
        this.eventPublisher = (EventPublisher)Mockito.mock(EventPublisher.class);
        this.groupMembershipManager = new DefaultGroupMembershipManager(this.crowdService, this.userDAO, this.eventPublisher);
        this.crowdTestRule.createInternalDirectory();
    }

    @Test
    public void testGetGroupsForUser_shouldReturnEmptyCollectionForNotActiveUser() throws Exception {
        this.createUsersAndGroups();
        List groups = this.groupMembershipManager.getGroupsForUser("non-existent");
        MatcherAssert.assertThat((Object)groups.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testGetGroupsForUser() throws Exception {
        this.createUsersAndGroups();
        List groups = this.groupMembershipManager.getGroupsForUser("user2");
        MatcherAssert.assertThat((Object)groups, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
    }

    @Test
    public void testGetGroupsForUser_withPaging() throws Exception {
        FecruUser user = this.createUser("user");
        for (int i = 0; i < 10; ++i) {
            this.addUserToGroup(user, this.createGroup("group" + i));
        }
        Page allGroups = this.groupMembershipManager.getGroupsForUser("user", PageRequest.create((Integer)0, (Integer)100));
        Page subGroups1 = this.groupMembershipManager.getGroupsForUser("user", PageRequest.create((Integer)3, (Integer)10));
        Page subGroups2 = this.groupMembershipManager.getGroupsForUser("user", PageRequest.create((Integer)1, (Integer)2));
        MatcherAssert.assertThat((Object)allGroups.getSize(), (Matcher)Is.is((Object)10));
        MatcherAssert.assertThat((Object)subGroups1.getSize(), (Matcher)Is.is((Object)7));
        MatcherAssert.assertThat((Object)subGroups2.getSize(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void testIsUserInGroup() throws Exception {
        this.createUsersAndGroups();
        MatcherAssert.assertThat((Object)this.groupMembershipManager.isUserInGroup("group1", "user1"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.groupMembershipManager.isUserInGroup("group1", "user2"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.groupMembershipManager.isUserInGroup("group2", "user1"), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.groupMembershipManager.isUserInGroup("group2", "user2"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testIsUserInAnyGroup() throws Exception {
        this.createUsersAndGroups();
        boolean isInAnyGroup1 = this.groupMembershipManager.isUserInAnyGivenGroup("user2", (List)ImmutableList.of());
        boolean isInAnyGroup2 = this.groupMembershipManager.isUserInAnyGivenGroup("user2", (List)ImmutableList.of((Object)"group1", (Object)"group3"));
        boolean isInAnyGroup3 = this.groupMembershipManager.isUserInAnyGivenGroup("user2", (List)ImmutableList.of((Object)"group3", (Object)"group4"));
        MatcherAssert.assertThat((Object)isInAnyGroup1, (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)isInAnyGroup2, (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)isInAnyGroup3, (Matcher)Is.is((Object)false));
    }

    @Test
    public void testAddUserToGroup() throws Exception {
        this.createUser("user");
        this.createGroup("group");
        this.groupMembershipManager.addUserToGroup("group", "user");
        MatcherAssert.assertThat((Object)this.crowdService.isUserMemberOfGroup("user", "group"), (Matcher)Is.is((Object)true));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish(org.mockito.Matchers.any(UserListChangedEvent.class));
    }

    @Test(expected=NotPermittedException.class)
    public void testAddUserToGroup_whenThrowsException() throws Exception {
        this.createUser("user");
        this.createGroup("group");
        this.disableUpdatingGroupsRule.disableNow();
        this.groupMembershipManager.addUserToGroup("group", "user");
    }

    @Test
    public void testTryAddUserToGroup_whenSuccessful() throws Exception {
        this.createUser("user");
        this.createGroup("group");
        boolean success = this.groupMembershipManager.tryAddUserToGroup("group", "user");
        MatcherAssert.assertThat((Object)success, (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.crowdService.isUserMemberOfGroup("user", "group"), (Matcher)Is.is((Object)true));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish(org.mockito.Matchers.any(UserListChangedEvent.class));
    }

    @Test
    public void testTryAddUserToGroup_whenThrowsException() throws Exception {
        this.createUser("user");
        this.createGroup("group");
        this.disableUpdatingGroupsRule.disableNow();
        boolean success = this.groupMembershipManager.tryAddUserToGroup("group", "user");
        MatcherAssert.assertThat((Object)success, (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.crowdService.isUserMemberOfGroup("user", "group"), (Matcher)Is.is((Object)false));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.never())).publish(org.mockito.Matchers.any(UserListChangedEvent.class));
    }

    @Test
    public void testRemoveUserFromGroup() throws Exception {
        this.createUsersAndGroups();
        this.groupMembershipManager.removeUserFromGroup("group1", "user1");
        MatcherAssert.assertThat((Object)this.crowdService.isUserMemberOfGroup("user1", "group1"), (Matcher)Is.is((Object)false));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish(org.mockito.Matchers.any(UserListChangedEvent.class));
    }

    @Test
    public void testRemoveUserFromGroup_shouldNotThrowWhenNotAMember() throws Exception {
        this.createUsersAndGroups();
        this.groupMembershipManager.removeUserFromGroup("group2", "user1");
    }

    @Test
    public void testGetUsersInGroup_shouldReturnEmptyCollectionForNonexistentGroup() throws Exception {
        List usersInGroup = this.groupMembershipManager.getUsersInGroup("non-existent-group");
        MatcherAssert.assertThat((Object)usersInGroup.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testGetUsersInGroup() throws Exception {
        this.createUsersAndGroups();
        List users = this.groupMembershipManager.getUsersInGroup("group1");
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{DefaultGroupMembershipManagerTest.matchesUsername("user1"), DefaultGroupMembershipManagerTest.matchesUsername("user2")}));
    }

    @Test
    public void testGetUsersInGroup_withPaging() throws Exception {
        Group group = this.createGroup("group");
        for (int i = 0; i < 10; ++i) {
            this.addUserToGroup(this.createUser("user" + i), group);
        }
        Page allUsers = this.groupMembershipManager.getUsersInGroup("group", PageRequest.create((Integer)0, (Integer)100));
        Page members1 = this.groupMembershipManager.getUsersInGroup("group", PageRequest.create((Integer)3, (Integer)10));
        Page members2 = this.groupMembershipManager.getUsersInGroup("group", PageRequest.create((Integer)1, (Integer)2));
        MatcherAssert.assertThat((Object)allUsers.getSize(), (Matcher)Is.is((Object)10));
        MatcherAssert.assertThat((Object)members1.getSize(), (Matcher)Is.is((Object)7));
        MatcherAssert.assertThat((Object)members2.getSize(), (Matcher)Is.is((Object)2));
    }

    private void createUsersAndGroups() throws Exception {
        FecruUser user1 = this.createUser("user1");
        FecruUser user2 = this.createUser("user2");
        Group group1 = this.createGroup("group1");
        Group group2 = this.createGroup("group2");
        this.addUserToGroup(user1, group1);
        this.addUserToGroup(user2, group1);
        this.addUserToGroup(user2, group2);
    }

    private FecruUser createUser(String userName) throws Exception {
        return this.createUser(userName, true);
    }

    private FecruUser createUser(String userName, boolean active) throws Exception {
        FecruUser user = new FecruUser(userName);
        this.userDAO.create(user);
        this.crowdService.addUser(new ImmutableUser.Builder().name(user.getUsername()).active(active).toUser(), "foobar");
        this.sessionFactory.getCurrentSession().flush();
        return user;
    }

    private Group createGroup(String groupName) throws OperationNotPermittedException, InvalidGroupException {
        return this.crowdService.addGroup((Group)new ImmutableGroup(groupName));
    }

    private void addUserToGroup(FecruUser user, Group group) throws OperationNotPermittedException {
        this.crowdService.addUserToGroup(new ImmutableUser.Builder().name(user.getUsername()).toUser(), group);
    }

    private static Matcher<FecruUser> matchesUsername(String username) {
        return Matchers.hasProperty((String)"username", (Matcher)Is.is((Object)username));
    }
}

