/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.event.api.EventPublisher;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.cenqua.fisheye.user.DefaultAdminUserConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class AdminUserConfigTest {
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    private AdminUserConfig adminUserConfig;
    private ConfigDocument.Config doc;

    @Before
    public void setUp() throws Exception {
        this.doc = ConfigDocument.Config.Factory.newInstance();
        this.doc.addNewSecurity().addNewAdmins().addNewSystemAdmins();
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getConfig()).thenReturn((Object)this.doc);
        this.adminUserConfig = new DefaultAdminUserConfig((EventPublisher)Mockito.mock(EventPublisher.class));
    }

    @Test
    public void shouldIgnoreCaseForAdminUsers() throws Exception {
        this.adminUserConfig.addUser("TOM");
        this.adminUserConfig.addUser("bom");
        boolean adminTom = this.adminUserConfig.isAdminUser("tom");
        boolean adminBom = this.adminUserConfig.isAdminUser("BOM");
        boolean adminFred = this.adminUserConfig.isAdminUser("fred");
        MatcherAssert.assertThat((Object)adminTom, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)adminBom, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)adminFred, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldIgnoreCaseForAdminGroups() throws Exception {
        this.adminUserConfig.addGroup("TOM");
        this.adminUserConfig.addGroup("bom");
        boolean adminTom = this.adminUserConfig.isAdminGroup("tom");
        boolean adminBom = this.adminUserConfig.isAdminGroup("BOM");
        boolean adminFred = this.adminUserConfig.isAdminGroup("fred");
        MatcherAssert.assertThat((Object)adminTom, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)adminBom, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)adminFred, (Matcher)Matchers.is((Object)false));
    }
}

