/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.fecru.user.AuthType;
import com.cenqua.fisheye.config1.AjpAuthConfigType;
import com.cenqua.fisheye.user.AJPAuth;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.UserLogin;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class AJPAuthTest {
    private AJPAuth auth;
    private MockHttpServletRequest requestWithUser = new MockHttpServletRequest();
    private String remoteUser = "user";

    @Before
    public void setUp() throws Exception {
        this.auth = new AJPAuth((AjpAuthConfigType)Mockito.mock(AjpAuthConfigType.class));
        this.requestWithUser.setRemoteUser(this.remoteUser);
    }

    @Test
    public void testGetToken() throws Exception {
        AuthTok userToken = this.auth.getToken((HttpServletRequest)this.requestWithUser, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertThat((Object)userToken.getUsername(), (Matcher)Matchers.equalTo((Object)this.remoteUser));
        Assert.assertThat((Object)userToken.getAuthType(), (Matcher)Matchers.equalTo((Object)AuthType.AJP));
    }

    @Test
    public void testGetToken_noUser() throws Exception {
        AuthTok noUserToken = this.auth.getToken((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertThat((Object)noUserToken, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAuthenticate() throws Exception {
        AuthTok userToken = this.auth.authenticate(this.remoteUser, "whatever", (HttpServletRequest)this.requestWithUser, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertThat((Object)userToken.getUsername(), (Matcher)Matchers.equalTo((Object)this.remoteUser));
        Assert.assertThat((Object)userToken.getAuthType(), (Matcher)Matchers.equalTo((Object)AuthType.AJP));
    }

    @Test
    public void testAuthenticate_noUser() throws Exception {
        AuthTok noUserToken = this.auth.authenticate(this.remoteUser, "whatever", (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertThat((Object)noUserToken, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testIsRequestStillValid() throws Exception {
        UserLogin userLogin = (UserLogin)Mockito.mock(UserLogin.class);
        Mockito.when((Object)userLogin.getUsername()).thenReturn((Object)this.remoteUser);
        boolean userReq = this.auth.isRequestUserStillValid(userLogin, (HttpServletRequest)this.requestWithUser, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertThat((Object)userReq, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testIsRequestStillValid_noUser() throws Exception {
        UserLogin userLogin = (UserLogin)Mockito.mock(UserLogin.class);
        Mockito.when((Object)userLogin.getUsername()).thenReturn((Object)this.remoteUser);
        boolean noUserReq = this.auth.isRequestUserStillValid(userLogin, (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertThat((Object)noUserReq, (Matcher)Is.is((Object)false));
    }
}

