/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax.r;

import com.cenqua.fisheye.syntax.RegexpMatchRule;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class LookBehindTest
extends TestCase {
    public void testLookBehind() {
        Pattern p = Pattern.compile("(?m)^foo");
        LookBehindTest.assertTrue((boolean)this.lookingAt(p, "foo", 0));
        LookBehindTest.assertFalse((boolean)this.lookingAt(p, " foo", 1));
        LookBehindTest.assertTrue((boolean)this.lookingAt(p, "\nfoo", 1));
        p = Pattern.compile("^(=(pod|head1|head2|item|over|back|for|begin|end))\\b", 8);
        LookBehindTest.assertTrue((boolean)this.lookingAt(p, "=head1 NAME\n", 0));
        LookBehindTest.assertTrue((boolean)this.lookingAt(p, "\r=head1 NAME\n", 1));
        LookBehindTest.assertTrue((boolean)this.lookingAt(p, "\n=head1 NAME\n", 1));
        LookBehindTest.assertTrue((boolean)this.lookingAt(p, "\r\n=head1 NAME\n", 2));
    }

    public void testZeroWidthLookBehind() {
        Pattern p = Pattern.compile("(?<=a)bb");
        LookBehindTest.assertTrue((boolean)this.lookingAt(p, "abb", 1));
        p = Pattern.compile("(?<= ~\\s{0,100}) /.*/", 4);
        LookBehindTest.assertTrue((boolean)this.lookingAt(p, "~ /foo/", 2));
        LookBehindTest.assertTrue((boolean)this.lookingAt(p, "~  /foo/", 3));
        LookBehindTest.assertFalse((boolean)this.lookingAt(p, "~ /foo/", 0));
        LookBehindTest.assertFalse((boolean)this.lookingAt(p, "~ /foo/", 1));
    }

    private boolean lookingAt(Pattern p, String test, int offset) {
        Matcher matcher = p.matcher(test);
        return RegexpMatchRule.lookingAt((Matcher)matcher, (int)offset, (int)test.length());
    }
}

