/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;

public abstract class SyntaxTestBase {
    protected void assertRegions(String snippet, Object ... args) {
        Assert.assertTrue((String)"You must specify sets of three region properties to assert: start (int), end (int) and type (String)", (args.length % 3 == 0 ? 1 : 0) != 0);
        List<Region> regions = this.lex(snippet);
        int expectedRegionCount = args.length / 3;
        Assert.assertEquals((String)("Wrong number of regions found for snippet:\n" + snippet + "\n" + this.toString(regions)), (int)expectedRegionCount, (int)regions.size());
        for (int i = 0; i < regions.size(); ++i) {
            Assert.assertEquals((String)("Incorrect region for snippet:\n" + snippet + "\n" + i + " start: " + regions.get(i)), (Object)args[i * 3], (Object)regions.get(i).getStart());
            Assert.assertEquals((String)("Incorrect region for snippet:\n" + snippet + "\n" + i + " end: " + regions.get(i)), (Object)args[i * 3 + 1], (Object)regions.get(i).getEnd());
            if (args[i * 3 + 2] instanceof String) {
                Assert.assertEquals((String)("Incorrect region for snippet:\n" + snippet + "\n" + i + " type: " + regions.get(i)), (Object)args[i * 3 + 2], (Object)regions.get(i).getPropertyValue("type"));
                continue;
            }
            if (!(args[i * 3 + 2] instanceof Map)) continue;
            Map map = (Map)args[i * 3 + 2];
            for (Map.Entry entry : map.entrySet()) {
                Map entriesNotPresent = Maps.difference((Map)regions.get(i).getProperties(), (Map)map).entriesOnlyOnRight();
                Assert.assertEquals((String)("Region for snippet:\n" + snippet + "\n" + i + " lacks the following properties/values: " + entriesNotPresent), (int)0, (int)entriesNotPresent.size());
            }
        }
    }

    private String toString(List<Region> regions) {
        StringBuilder str = new StringBuilder();
        for (Region region : regions) {
            str.append(region);
            str.append("\n");
        }
        return str.toString();
    }

    private List<Region> lex(String input) {
        SyntaxDefinition definition = new SyntaxDefinitions(Collections.singletonList(new File(FisheyeTestEnv.WORKSPACE_DIR, "etc/dist/syntax"))).getSyntaxDefinitionForFile(this.getDummyFileName());
        RegionList regionList = new RegionList();
        definition.generateRegions(new InputState((CharSequence)input), regionList);
        return regionList.asList();
    }

    protected abstract String getDummyFileName();

    protected Map<String, String> kvp(String ... kvps) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < kvps.length; i += 2) {
            map.put(kvps[i], kvps[i + 1]);
        }
        return map;
    }
}

