/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.TestCase;

public class SyntaxDefinitionTest
extends TestCase {
    public void testSyntaxDefStructures() {
        SyntaxDefinition sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { \"foo\" :;}"));
        RegionList expected = new RegionList();
        this.generateRegionsAndCheck(sd, "", expected);
        this.generateRegionsAndCheck(sd, "bar", expected);
        this.generateRegionsAndCheck(sd, "foofoobarfoo", expected);
        sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { \"foo\" : { region {type=foo;}}}"));
        expected.clear();
        this.generateRegionsAndCheck(sd, "", expected);
        this.generateRegionsAndCheck(sd, "bar", expected);
        expected.add(this.getTypedRegion(0, 3, "foo"));
        expected.add(this.getTypedRegion(3, 6, "foo"));
        expected.add(this.getTypedRegion(9, 12, "foo"));
        this.generateRegionsAndCheck(sd, "foofoobarfoo", expected);
        sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { /foo[^b]*/ : { region {type=foo;}}}"));
        expected.clear();
        this.generateRegionsAndCheck(sd, "", expected);
        this.generateRegionsAndCheck(sd, "bar", expected);
        expected.add(this.getTypedRegion(0, 6, "foo"));
        expected.add(this.getTypedRegion(9, 12, "foo"));
        this.generateRegionsAndCheck(sd, "foofoobarfoo", expected);
        sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { /foo[^b]*/i : { region {type=foo;}}}"));
        expected.clear();
        this.generateRegionsAndCheck(sd, "", expected);
        this.generateRegionsAndCheck(sd, "bar", expected);
        expected.add(this.getTypedRegion(0, 6, "foo"));
        expected.add(this.getTypedRegion(9, 12, "foo"));
        this.generateRegionsAndCheck(sd, "fOofoobarFoO", expected);
        sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { /foo([^b]*)/ : { region {type=foo;} region ${1} {type=goo;}}}"));
        expected.clear();
        this.generateRegionsAndCheck(sd, "", expected);
        this.generateRegionsAndCheck(sd, "bar", expected);
        expected.add(this.getTypedRegion(0, 6, "foo"));
        expected.add(this.getTypedRegion(3, 6, "goo"));
        expected.add(this.getTypedRegion(9, 12, "foo"));
        this.generateRegionsAndCheck(sd, "foogoobarfoo", expected);
        sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { \"foo\" : { foo; region {type=foo;} } context foo { \"foo\" : {region {type=foo2;}} \"bar\" : exit; }}"));
        expected.clear();
        this.generateRegionsAndCheck(sd, "", expected);
        this.generateRegionsAndCheck(sd, "bar", expected);
        expected.add(this.getTypedRegion(0, 3, "foo"));
        expected.add(this.getTypedRegion(3, 6, "foo2"));
        expected.add(this.getTypedRegion(9, 12, "foo"));
        this.generateRegionsAndCheck(sd, "foofoobarfoo", expected);
        sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { /foo([^b]*)/ : { foo(${1}); region {type=foo;} } context foo { \"foo\" : {region {type=foo2;}}}}"));
        expected.clear();
        this.generateRegionsAndCheck(sd, "", expected);
        this.generateRegionsAndCheck(sd, "bar", expected);
        expected.add(this.getTypedRegion(0, 6, "foo"));
        expected.add(this.getTypedRegion(3, 6, "foo2"));
        expected.add(this.getTypedRegion(9, 12, "foo"));
        this.generateRegionsAndCheck(sd, "foofoobarfoo", expected);
        sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { /\"/ : {context {/\\\\\"/: ; /\\\\./:; /$/m : exit; \"\\\"\": exit; } region ${ALL} { type=string;}}}"));
        expected.clear();
        this.generateRegionsAndCheck(sd, "", expected);
        this.generateRegionsAndCheck(sd, "bar", expected);
        expected.add(this.getTypedRegion(0, 8, "string"));
        expected.add(this.getTypedRegion(9, 16, "string"));
        this.generateRegionsAndCheck(sd, "\"foofoo\"a\"b\\\"ar\"foo", expected);
    }

    public void testLookBehind() {
        SyntaxDefinition sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { /\\bfor\\b/ : { region {type=keyword;} } /[a-z][a-z0-9]+/ : { region {type=ident;} } }"));
        RegionList expected = new RegionList();
        expected.add(this.getTypedRegion(1, 4, "ident"));
        this.generateRegionsAndCheck(sd, "0for", expected);
        expected.clear();
        expected.add(this.getTypedRegion(0, 4, "ident"));
        expected.add(this.getTypedRegion(6, 9, "ident"));
        expected.add(this.getTypedRegion(11, 15, "ident"));
        expected.add(this.getTypedRegion(17, 20, "keyword"));
        this.generateRegionsAndCheck(sd, "for0 0for 0for0 -for-", expected);
        sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { /^foo/m : { region {type=foo;} } }"));
        expected.clear();
        this.generateRegionsAndCheck(sd, " foo", expected);
        expected.add(this.getTypedRegion(5, 8, "foo"));
        this.generateRegionsAndCheck(sd, " foo\nfoo", expected);
    }

    public void testLargeStarMatch() {
        int largeSize = 60000;
        StringBuilder largeInput = new StringBuilder(60003);
        largeInput.append("'");
        for (int i = 0; i < 60000; ++i) {
            largeInput.append((char)(97 + i % 26));
        }
        largeInput.append("'");
        SyntaxDefinition sd = SyntaxDefinitionTest.parseSyntaxDef(new StringReader("syntaxdef test { context strEnd {\"'\" : exit;} \"'\" : { context {\"'\" : exit;}  region  ${ALL} {type=foo;}}}"));
        RegionList expected = new RegionList();
        expected.add(this.getTypedRegion(0, largeInput.length(), "foo"));
        this.generateRegionsAndCheck(sd, largeInput.toString(), expected);
    }

    private Region getTypedRegion(int start, int end, String type) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", type);
        return new Region(start, end, props);
    }

    private void generateRegionsAndCheck(SyntaxDefinition sd, String input, RegionList expected) {
        RegionList out = new RegionList();
        InputState in = new InputState((CharSequence)input);
        sd.generateRegions(in, out);
        SyntaxDefinitionTest.assertEquals((int)expected.size(), (int)out.size());
        Iterator o = out.iterator();
        Iterator e = expected.iterator();
        while (o.hasNext()) {
            Region or = (Region)o.next();
            Region er = (Region)e.next();
            SyntaxDefinitionTest.assertTrue((String)(er + " vs " + or), (boolean)or.sameSpan(er));
            SyntaxDefinitionTest.assertEquals((Object)er.getProperties(), (Object)or.getProperties());
        }
    }

    public static SyntaxDefinition parseSyntaxDef(String in) {
        return SyntaxDefinitionTest.parseSyntaxDef(new StringReader(in));
    }

    public static SyntaxDefinition parseSyntaxDef(Reader in) {
        LinkedList errors = new LinkedList();
        SyntaxDefinition sd = SyntaxDefinition.parse((Reader)in, errors);
        if (!errors.isEmpty()) {
            System.out.println(errors);
        }
        SyntaxDefinitionTest.assertEquals((int)0, (int)errors.size());
        return sd;
    }
}

