/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringLiteralsSyntaxDefinitionTest {
    private static final String STRING = "string";
    private static final String TYPE = "type";
    private SyntaxDefinitions syntaxDefinitions;

    @Before
    public void setUp() throws Exception {
        ArrayList dirs = Lists.newArrayList();
        dirs.add(new File(FisheyeTestEnv.WORKSPACE_DIR, "etc/dist/syntax"));
        this.syntaxDefinitions = new SyntaxDefinitions((List)dirs);
    }

    @Test
    public void testJavaWithEscaping() throws Exception {
        String input = "\"some \\\"string in java\"";
        String filename = "test.java";
        List resultWithEscaping = this.syntaxDefinitions.getRegionsForFile("test.java", (CharSequence)"\"some \\\"string in java\"").getRegions().asList();
        this.assertStringLiteralRegion(resultWithEscaping, 0, 23);
    }

    @Test
    public void testJavaWithoutEscaping() throws Exception {
        String input = "\"some string in java\"";
        String filename = "test.java";
        List result = this.syntaxDefinitions.getRegionsForFile("test.java", (CharSequence)"\"some string in java\"").getRegions().asList();
        this.assertStringLiteralRegion(result, 0, 21);
    }

    @Test
    public void testCSharpWithEscaping() throws Exception {
        String input = "\"some string\\\" in csharp\"";
        String filename = "test.cs";
        List result = this.syntaxDefinitions.getRegionsForFile("test.cs", (CharSequence)"\"some string\\\" in csharp\"").getRegions().asList();
        this.assertStringLiteralRegion(result, 0, 25);
    }

    @Test
    public void testCSharpVerbatimWithDoubleQuotesInline() throws Exception {
        String input = "@\"some verbatim string\"\"in csharp\"";
        String filename = "test.cs";
        List result = this.syntaxDefinitions.getRegionsForFile("test.cs", (CharSequence)"@\"some verbatim string\"\"in csharp\"").getRegions().asList();
        this.assertStringLiteralRegion(result, 0, 34);
    }

    @Test
    public void testVbNetWithDoubleQuotesInline() throws Exception {
        String input = "\"some string\"\" in visual basic\"";
        String filename = "test.vb";
        List result = this.syntaxDefinitions.getRegionsForFile("test.vb", (CharSequence)"\"some string\"\" in visual basic\"").getRegions().asList();
        this.assertStringLiteralRegion(result, 0, 31);
    }

    @Test
    public void testJavaScriptWithEscaping() throws Exception {
        String input = "\"some string\\\" in javascript\"";
        String filename = "test.js";
        List result = this.syntaxDefinitions.getRegionsForFile("test.js", (CharSequence)"\"some string\\\" in javascript\"").getRegions().asList();
        this.assertStringLiteralRegion(result, 0, 29);
    }

    private void assertStringLiteralRegion(List<Region> result, int regionStart, int regionEnd) {
        Region resultRegion = result.get(0);
        Assert.assertEquals((String)"For given string there should be only one region", (long)1L, (long)result.size());
        Assert.assertEquals((String)"Region should be type string", (Object)STRING, (Object)resultRegion.getPropertyValue(TYPE));
        Assert.assertEquals((String)"Region start should match 0", (long)regionStart, (long)resultRegion.getStart());
        Assert.assertEquals((String)"Region end should match input length", (long)regionEnd, (long)resultRegion.getEnd());
    }
}

