/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.SortedRegionSet;
import java.util.Iterator;
import junit.framework.TestCase;

public class SortedRegionSetTest
extends TestCase {
    public void testAdditions() {
        SortedRegionSet list = new SortedRegionSet();
        Region r0 = new Region(2, 4);
        list.add(r0);
        this.assertSetEquals(list, new Region[]{r0});
        this.assertMaxEndInvariant(list);
        Region r1 = new Region(4, 5);
        list.add(r1);
        this.assertSetEquals(list, new Region[]{r0, r1});
        this.assertMaxEndInvariant(list);
        Region r2 = new Region(6, 8);
        list.add(r2);
        this.assertSetEquals(list, new Region[]{r0, r1, r2});
        this.assertMaxEndInvariant(list);
        Region r3 = new Region(1, 4);
        list.add(r3);
        this.assertSetEquals(list, new Region[]{r3, r0, r1, r2});
        this.assertMaxEndInvariant(list);
        Region r4 = new Region(1, 6);
        list.add(r4);
        this.assertSetEquals(list, new Region[]{r4, r3, r0, r1, r2});
        this.assertMaxEndInvariant(list);
        Region r5 = new Region(10, 11);
        list.add(r5);
        this.assertSetEquals(list, new Region[]{r4, r3, r0, r1, r2, r5});
        this.assertMaxEndInvariant(list);
        SortedRegionSetTest.assertEquals((int)0, (int)list.indexOfFirstAt(0));
        SortedRegionSetTest.assertEquals((int)0, (int)list.indexOfFirstAt(1));
        SortedRegionSetTest.assertEquals((int)0, (int)list.indexOfFirstAt(2));
        SortedRegionSetTest.assertEquals((int)0, (int)list.indexOfFirstAt(3));
        SortedRegionSetTest.assertEquals((int)0, (int)list.indexOfFirstAt(4));
        SortedRegionSetTest.assertEquals((int)0, (int)list.indexOfFirstAt(5));
        SortedRegionSetTest.assertEquals((int)0, (int)list.indexOfFirstAt(6));
        SortedRegionSetTest.assertEquals((Object)r4, (Object)list.get(0));
        SortedRegionSetTest.assertEquals((int)4, (int)list.indexOfFirstAt(7));
        SortedRegionSetTest.assertEquals((int)4, (int)list.indexOfFirstAt(8));
        SortedRegionSetTest.assertEquals((Object)r2, (Object)list.get(4));
        SortedRegionSetTest.assertEquals((int)5, (int)list.indexOfFirstAt(9));
        SortedRegionSetTest.assertEquals((int)5, (int)list.indexOfFirstAt(10));
        SortedRegionSetTest.assertEquals((int)5, (int)list.indexOfFirstAt(11));
        SortedRegionSetTest.assertEquals((int)5, (int)list.indexOfFirstAt(12));
        SortedRegionSetTest.assertEquals((Object)r5, (Object)list.get(5));
    }

    public void testIterationBetween() {
        Region r1 = new Region(10, 100);
        Region r2 = new Region(10, 15);
        Region r3 = new Region(95, 100);
        SortedRegionSet list = new SortedRegionSet();
        list.add(r1);
        list.add(r2);
        list.add(r3);
        this.assertMaxEndInvariant(list);
        this.assertSetEquals(list.iterator(), new Region[]{r1, r2, r3});
        this.assertSetEquals(list.iterateBetween(0, 5), new Region[0]);
        this.assertSetEquals(list.iterateBetween(0, 10), new Region[0]);
        this.assertSetEquals(list.iterateBetween(10, 100), new Region[]{r1, r2, r3});
        this.assertSetEquals(list.iterateBetween(0, 100), new Region[]{r1, r2, r3});
        this.assertSetEquals(list.iterateBetween(10, 200), new Region[]{r1, r2, r3});
        this.assertSetEquals(list.iterateBetween(0, 200), new Region[]{r1, r2, r3});
        this.assertSetEquals(list.iterateBetween(10, 15), new Region[]{r1, r2});
        this.assertSetEquals(list.iterateBetween(0, 15), new Region[]{r1, r2});
        this.assertSetEquals(list.iterateBetween(10, 20), new Region[]{r1, r2});
        this.assertSetEquals(list.iterateBetween(0, 20), new Region[]{r1, r2});
        this.assertSetEquals(list.iterateBetween(15, 20), new Region[]{r1});
        this.assertSetEquals(list.iterateBetween(17, 20), new Region[]{r1});
        this.assertSetEquals(list.iterateBetween(15, 95), new Region[]{r1});
        this.assertSetEquals(list.iterateBetween(17, 95), new Region[]{r1});
        this.assertSetEquals(list.iterateBetween(15, 97), new Region[]{r1, r3});
        this.assertSetEquals(list.iterateBetween(15, 100), new Region[]{r1, r3});
        this.assertSetEquals(list.iterateBetween(95, 100), new Region[]{r1, r3});
        this.assertSetEquals(list.iterateBetween(97, 100), new Region[]{r1, r3});
        this.assertSetEquals(list.iterateBetween(100, 120), new Region[0]);
        this.assertSetEquals(list.iterateBetween(110, 120), new Region[0]);
    }

    public void testRegionComparators() {
        Region r1 = new Region(0, 100);
        Region r2 = new Region(200, 300);
        Region r3 = new Region(0, 50);
        Region r4 = new Region(0, 50);
        SortedRegionSetTest.assertTrue((this.compare(null, null) == 0 ? 1 : 0) != 0);
        SortedRegionSetTest.assertTrue((this.compare(null, r1) < 0 ? 1 : 0) != 0);
        SortedRegionSetTest.assertTrue((this.compare(r1, null) > 0 ? 1 : 0) != 0);
        SortedRegionSetTest.assertTrue((this.compare(r1, r2) < 0 ? 1 : 0) != 0);
        SortedRegionSetTest.assertTrue((this.compare(r2, r1) > 0 ? 1 : 0) != 0);
        SortedRegionSetTest.assertTrue((this.compare(r1, r3) < 0 ? 1 : 0) != 0);
        SortedRegionSetTest.assertTrue((this.compare(r3, r1) > 0 ? 1 : 0) != 0);
        SortedRegionSetTest.assertTrue((this.compare(r3, r4) == 0 ? 1 : 0) != 0);
        SortedRegionSetTest.assertTrue((this.compare(r4, r3) == 0 ? 1 : 0) != 0);
    }

    private int compare(Region a, Region b) {
        SortedRegionSet.LineSegment la = a == null ? null : new SortedRegionSet.LineSegment(a, 0);
        SortedRegionSet.LineSegment lb = b == null ? null : new SortedRegionSet.LineSegment(b, 0);
        return SortedRegionSet.COMP.compare(la, lb);
    }

    private void assertSetEquals(SortedRegionSet list, Region[] regions) {
        SortedRegionSetTest.assertEquals((int)list.size(), (int)regions.length);
        Iterator iter = list.iterator();
        this.assertSetEquals(iter, regions);
    }

    private void assertSetEquals(Iterator iter, Region[] regions) {
        int i = 0;
        while (iter.hasNext()) {
            SortedRegionSetTest.assertTrue((String)("more than expected " + i), (i < regions.length ? 1 : 0) != 0);
            Region a = (Region)iter.next();
            Region expected = regions[i++];
            SortedRegionSetTest.assertEquals((Object)a, (Object)expected);
        }
        SortedRegionSetTest.assertEquals((int)regions.length, (int)i);
    }

    private void assertMaxEndInvariant(SortedRegionSet list) {
        int maxEnd = 0;
        for (SortedRegionSet.LineSegment seg : list.segs) {
            SortedRegionSetTest.assertTrue((seg.maxEndOffset >= seg.region.getEnd() ? 1 : 0) != 0);
            maxEnd = Math.max(maxEnd, seg.region.getEnd());
            SortedRegionSetTest.assertEquals((int)maxEnd, (int)seg.maxEndOffset);
        }
    }
}

