/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.Region;
import java.util.HashMap;
import junit.framework.TestCase;

public class RegionTest
extends TestCase {
    public void testTranslate() {
        int end = 100;
        Region o = new Region(0, end);
        Region t1 = o.translate(end);
        RegionTest.assertTrue((o.getStart() + end == t1.getStart() ? 1 : 0) != 0);
        RegionTest.assertTrue((o.getEnd() + end == t1.getEnd() ? 1 : 0) != 0);
        RegionTest.assertTrue((o.getProperties() == null ? 1 : 0) != 0);
        Region t2 = t1.translate(-end);
        RegionTest.assertFalse((boolean)t2.sameSpan(t1));
        RegionTest.assertTrue((boolean)t2.sameSpan(o));
        Region t3 = o.translate(0);
        RegionTest.assertTrue((boolean)t3.sameSpan(o));
    }

    public void testSubregion() {
        int end = 100;
        Region o = new Region(0, end);
        Region s1 = o.subRegion(0, end / 2);
        Region s2 = o.subRegion(end / 2, end);
        RegionTest.assertTrue((s1.getStart() == 0 && s1.getEnd() == end / 2 ? 1 : 0) != 0);
        RegionTest.assertTrue((s2.getStart() == end / 2 && s2.getEnd() == end ? 1 : 0) != 0);
        HashMap<String, String> p1 = new HashMap<String, String>();
        p1.put("key", "value");
        o = new Region(0, end, p1);
        RegionTest.assertTrue((boolean)((String)o.getProperties().get("key")).equals("value"));
        HashMap<String, String> p2 = new HashMap<String, String>();
        p2.put("foo", "bar");
        s1 = new Region(o, p2);
        RegionTest.assertTrue((s1.getProperties().get("key") == null ? 1 : 0) != 0);
        RegionTest.assertTrue((boolean)((String)s1.getProperties().get("foo")).equals("bar"));
    }

    public void testIntersection() {
        Region r = new Region(100, 200);
        Region before = new Region(0, 50);
        Region after = new Region(250, 300);
        Region startOver = new Region(50, 150);
        Region endOver = new Region(150, 250);
        Region nesting = new Region(50, 250);
        Region nested = new Region(120, 180);
        Region adjacent = new Region(200, 300);
        RegionTest.assertTrue((r.intersection(before) == null ? 1 : 0) != 0);
        RegionTest.assertFalse((boolean)r.isNestedBy(before));
        RegionTest.assertFalse((boolean)r.nests(before));
        RegionTest.assertTrue((r.intersection(after) == null ? 1 : 0) != 0);
        RegionTest.assertFalse((boolean)r.isNestedBy(after));
        RegionTest.assertFalse((boolean)r.nests(after));
        RegionTest.assertTrue((boolean)r.intersection(startOver).sameSpan(new Region(100, 150)));
        RegionTest.assertFalse((boolean)r.isNestedBy(startOver));
        RegionTest.assertFalse((boolean)r.nests(startOver));
        RegionTest.assertTrue((boolean)r.intersection(endOver).sameSpan(new Region(150, 200)));
        RegionTest.assertFalse((boolean)r.isNestedBy(endOver));
        RegionTest.assertFalse((boolean)r.nests(endOver));
        RegionTest.assertTrue((boolean)r.intersection(nesting).sameSpan(r));
        RegionTest.assertTrue((boolean)r.isNestedBy(nesting));
        RegionTest.assertFalse((boolean)r.nests(nesting));
        RegionTest.assertTrue((boolean)r.intersection(nested).sameSpan(nested));
        RegionTest.assertFalse((boolean)r.isNestedBy(nested));
        RegionTest.assertTrue((boolean)r.nests(nested));
        RegionTest.assertTrue((boolean)r.intersection(r).sameSpan(r));
        RegionTest.assertTrue((boolean)r.isNestedBy(r));
        RegionTest.assertTrue((boolean)r.nests(r));
        RegionTest.assertTrue((r.intersection(adjacent) == null ? 1 : 0) != 0);
        RegionTest.assertFalse((boolean)r.isNestedBy(adjacent));
        RegionTest.assertFalse((boolean)r.nests(adjacent));
        RegionTest.assertTrue((adjacent.intersection(r) == null ? 1 : 0) != 0);
        RegionTest.assertFalse((boolean)adjacent.isNestedBy(r));
        RegionTest.assertFalse((boolean)adjacent.nests(r));
    }

    public void testExceptional() {
        Region o2;
        try {
            o2 = new Region(-1, 0);
            RegionTest.fail((String)"IOOBE expected");
        }
        catch (IndexOutOfBoundsException o2) {
            // empty catch block
        }
        try {
            o2 = new Region(0, -1);
            RegionTest.fail((String)"IOOBE expected");
        }
        catch (IndexOutOfBoundsException o3) {
            // empty catch block
        }
        try {
            o2 = new Region(1, 0);
            RegionTest.fail((String)"IOOBE expected");
        }
        catch (IndexOutOfBoundsException o4) {
            // empty catch block
        }
        try {
            o2 = new Region(0, 0);
            o2.subRegion(0, 1);
            RegionTest.fail((String)"IOOBE expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

