/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.RegionListVisitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public class RegionListTest
extends TestCase {
    public void testAddingOverlappingRegions() {
        Region a1 = new Region(0, 100);
        RegionList a = new RegionList();
        a.add(a1);
        Region b1 = new Region(50, 150);
        RegionList b = new RegionList();
        b.add(b1);
        a.merge(b);
        List l = a.asList();
        RegionListTest.assertEquals((int)3, (int)l.size());
    }

    public void testSubSet() {
        RegionList regions = new RegionList();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("key1", "value1");
        Region r1 = new Region(0, 100, props);
        props.put("key2", "value2");
        Region r2 = new Region(0, 5, props);
        props.put("key3", "value3");
        Region r3 = new Region(95, 100, props);
        regions.add(r1);
        regions.add(r2);
        regions.add(r3);
        RegionList sub = regions.getSubset(0, 100);
        RegionListTest.assertEquals((int)3, (int)sub.size());
        Iterator it = sub.iterator();
        RegionListTest.assertTrue((boolean)it.hasNext());
        Region cr1 = (Region)it.next();
        RegionListTest.assertTrue((boolean)r1.sameSpan(cr1));
        Region cr2 = (Region)it.next();
        RegionListTest.assertTrue((boolean)r2.sameSpan(cr2));
        Region cr3 = (Region)it.next();
        RegionListTest.assertTrue((boolean)r3.sameSpan(cr3));
        RegionListTest.assertTrue((!it.hasNext() ? 1 : 0) != 0);
        sub = regions.getSubset(100, 110);
        RegionListTest.assertEquals((int)0, (int)sub.size());
        RegionListTest.assertTrue((!sub.iterator().hasNext() ? 1 : 0) != 0);
        sub = regions.getSubset(95, 100);
        RegionListTest.assertEquals((int)2, (int)sub.size());
        it = sub.iterator();
        RegionListTest.assertTrue((boolean)it.hasNext());
        cr1 = (Region)it.next();
        RegionListTest.assertTrue((boolean)r3.sameSpan(cr1));
        cr2 = (Region)it.next();
        RegionListTest.assertTrue((boolean)r3.sameSpan(cr2));
        sub = regions.getSubset(0, 5);
        RegionListTest.assertEquals((int)2, (int)sub.size());
        it = sub.iterator();
        RegionListTest.assertTrue((boolean)it.hasNext());
        cr1 = (Region)it.next();
        RegionListTest.assertTrue((boolean)r2.sameSpan(cr1));
        cr2 = (Region)it.next();
        RegionListTest.assertTrue((boolean)r2.sameSpan(cr2));
        sub = regions.getSubset(10, 80);
        RegionListTest.assertEquals((int)1, (int)sub.size());
        sub = sub.getSubset(20, 60);
        RegionListTest.assertEquals((int)1, (int)sub.size());
        it = sub.iterator();
        RegionListTest.assertTrue((boolean)it.hasNext());
        cr1 = (Region)it.next();
        RegionListTest.assertEquals((int)20, (int)cr1.getStart());
        RegionListTest.assertEquals((int)60, (int)cr1.getEnd());
    }

    public void testTranslateAndAddAll() {
        RegionList regions = new RegionList();
        Region r1 = new Region(0, 100);
        Region r2 = new Region(0, 5);
        Region r3 = new Region(95, 100);
        regions.add(r1);
        regions.add(r2);
        regions.add(r3);
        regions.translate(100);
        RegionListTest.assertTrue((regions.size() == 3 ? 1 : 0) != 0);
        Iterator it = regions.iterator();
        RegionListTest.assertTrue((boolean)it.hasNext());
        Region cr1 = (Region)it.next();
        RegionListTest.assertTrue((boolean)cr1.sameSpan(r1.translate(100)));
        Region cr2 = (Region)it.next();
        RegionListTest.assertTrue((boolean)cr2.sameSpan(r2.translate(100)));
        Region cr3 = (Region)it.next();
        RegionListTest.assertTrue((boolean)cr3.sameSpan(r3.translate(100)));
        RegionListTest.assertTrue((!it.hasNext() ? 1 : 0) != 0);
        RegionList rl2 = new RegionList();
        rl2.addAll(regions);
        it = rl2.iterator();
        RegionListTest.assertTrue((boolean)it.hasNext());
        cr1 = (Region)it.next();
        RegionListTest.assertTrue((boolean)cr1.sameSpan(r1.translate(100)));
        cr2 = (Region)it.next();
        RegionListTest.assertTrue((boolean)cr2.sameSpan(r2.translate(100)));
        cr3 = (Region)it.next();
        RegionListTest.assertTrue((boolean)cr3.sameSpan(r3.translate(100)));
        RegionListTest.assertTrue((!it.hasNext() ? 1 : 0) != 0);
    }

    public void testNormalizedList() {
        Region r1 = new Region(100, 200);
        Region r2 = new Region(50, 150);
        Region r3 = new Region(150, 300);
        Region r4 = new Region(120, 170);
        Region r5 = new Region(160, 180);
        RegionList regions = new RegionList();
        regions.add(r2);
        regions.add(r1);
        regions.add(r3);
        regions.add(r4);
        regions.add(r5);
        RegionList normal = regions;
        LinkedList<Region> expected = new LinkedList<Region>();
        expected.add(new Region(50, 150));
        expected.add(new Region(100, 150));
        expected.add(new Region(120, 150));
        expected.add(new Region(150, 300));
        expected.add(new Region(150, 200));
        expected.add(new Region(150, 170));
        expected.add(new Region(160, 170));
        expected.add(new Region(170, 180));
        RegionListTest.assertEquals((int)expected.size(), (int)normal.size());
        Iterator actual = normal.iterator();
        Iterator expect = expected.iterator();
        while (actual.hasNext() && expect.hasNext()) {
            Region ar = (Region)actual.next();
            Region er = (Region)expect.next();
            RegionListTest.assertTrue((String)("expected " + er + ", got " + ar), (boolean)ar.sameSpan(er));
        }
    }

    public void testVisitRegions() throws IOException {
        RegionList regions = new RegionList();
        Region r1 = new Region(0, 100);
        Region r2 = new Region(0, 5);
        Region r3 = new Region(95, 100);
        regions.add(r1);
        regions.add(r2);
        regions.add(r3);
        final LinkedList<Region> expectedOrder = new LinkedList<Region>();
        expectedOrder.add(r1);
        expectedOrder.add(r2);
        expectedOrder.add(r2);
        expectedOrder.add(r3);
        expectedOrder.add(r3);
        expectedOrder.add(r1);
        final int initialsize = expectedOrder.size();
        regions.visitRegions(new RegionListVisitor(){

            public void start() {
                TestCase.assertTrue((expectedOrder.size() == initialsize ? 1 : 0) != 0);
            }

            public void regionStart(Region region) {
                Region r = (Region)expectedOrder.removeFirst();
                TestCase.assertTrue((String)("expecting " + r + ", got " + region), (r == region ? 1 : 0) != 0);
            }

            public void regionEnd(Region region) {
                Region r = (Region)expectedOrder.removeFirst();
                TestCase.assertTrue((String)("expecting " + r + ", got " + region), (r == region ? 1 : 0) != 0);
            }

            public void end() {
            }
        });
    }
}

