/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionGenerator;
import com.cenqua.fisheye.syntax.RegionList;
import java.util.HashMap;
import junit.framework.TestCase;

public class RegionGeneratorTest
extends TestCase {
    public void testGenerate() {
        InputState in = new InputState((CharSequence)"public void static main(String [] args) {}");
        RegionGenerator rg = new RegionGenerator();
        RegionList regions = new RegionList();
        HashMap<String, Region> matchRegions = new HashMap<String, Region>();
        rg.setProperty("matchtext", "${0}");
        rg.setProperty("notfound", "${20}");
        Region reg = new Region(0, 23);
        matchRegions.put("0", reg);
        rg.generate(in, matchRegions, regions);
        RegionGeneratorTest.assertTrue((regions.size() == 1 ? 1 : 0) != 0);
        Region out = (Region)regions.iterator().next();
        RegionGeneratorTest.assertTrue((boolean)out.sameSpan(reg));
        RegionGeneratorTest.assertTrue((boolean)((String)out.getProperties().get("matchtext")).equals(in.getSubSequence(reg)));
        RegionGeneratorTest.assertTrue((boolean)((String)out.getProperties().get("notfound")).equals("${20}"));
        rg.setSubmatchRef("4");
        RegionGeneratorTest.assertTrue((boolean)"4".equals(rg.getSubmatchRef()));
        matchRegions.clear();
        rg.generate(in, matchRegions, regions);
        RegionGeneratorTest.assertTrue((regions.size() == 1 ? 1 : 0) != 0);
    }
}

