/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.ParenthesesBalancingRegionFilter;
import com.cenqua.fisheye.syntax.Region;
import java.util.HashMap;
import junit.framework.TestCase;

public class ParenthesesBalancingTest
extends TestCase {
    private final String baseUrl = "http://www.domain.com/";
    private ParenthesesBalancingRegionFilter filter;

    public void setUp() {
        this.filter = new ParenthesesBalancingRegionFilter();
    }

    public void testOneTrailingParenBalanced() {
        String url = "http://www.domain.com/thi(s)";
        this.checkBalanced(url);
    }

    public void testOneTrailingParenUnBalanced() {
        String url = "http://www.domain.com/this)";
        String correctUrl = "http://www.domain.com/this";
        this.checkUnbalanced(url, correctUrl);
    }

    public void testSeveralTrailingParenBalanced() {
        String url = "http://www.domain.com/th(i((s)))";
        this.checkBalanced(url);
    }

    public void testSeveralTrailingParenUnBalanced() {
        String url = "http://www.domain.com/th(i(s)))";
        String correctUrl = "http://www.domain.com/th(i(s))";
        this.checkUnbalanced(url, correctUrl);
    }

    public void testBalancedTrailingBalancedContaining() {
        String url = "http://www.domain.com/th(i(()(()s)))";
        this.checkBalanced(url);
    }

    public void testUnBalancedTrailingBalancedContaining() {
        String url = "http://www.domain.com/th(i(()(()s))))";
        String correctUrl = "http://www.domain.com/th(i(()(()S)))";
        this.checkUnbalanced(url, correctUrl);
    }

    public void testBalancedTrailingUnBalancedContaining() {
        String url = "http://www.domain.com/th(i(((()s)))";
        this.checkBalanced(url);
    }

    public void testUnBalancedTrailingUnBalancedContaining() {
        String url = "http://www.domain.com/th)(is)))";
        String correctUrl = "http://www.domain.com/th)(is)";
        this.checkUnbalanced(url, correctUrl);
    }

    private void checkUnbalanced(CharSequence testUrl, String correctUrl) {
        HashMap<String, String> testMap = new HashMap<String, String>();
        HashMap<String, String> correctMap = new HashMap<String, String>();
        correctMap.put("key", correctUrl);
        testMap.put("key", testUrl.toString());
        Region testRegion = new Region(5, 5 + testUrl.length(), testMap);
        Region expectedRegion = new Region(5, 5 + correctUrl.length(), correctMap);
        testRegion = this.filter.filter((CharSequence)("12345" + testUrl + "etc blah"), testRegion);
        this.assertExpected(expectedRegion, testRegion);
    }

    private void checkBalanced(CharSequence url) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", url.toString());
        Region testRegion = new Region(4, 4 + url.length(), map);
        Region expectedRegion = new Region(4, 4 + url.length(), map);
        testRegion = this.filter.filter((CharSequence)("lala" + url + "blah"), testRegion);
        this.assertExpected(expectedRegion, testRegion);
    }

    private void assertExpected(Region expected, Region actual) {
        ParenthesesBalancingTest.assertEquals((String)"Wrong end for region: ", (int)expected.getEnd(), (int)actual.getEnd());
        ParenthesesBalancingTest.assertEquals((String)"Wrong start for region: ", (int)expected.getStart(), (int)actual.getStart());
    }
}

