/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.MatchAction;
import com.cenqua.fisheye.syntax.RegexpMatchRule;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.StringMatchRule;
import java.util.Map;
import junit.framework.TestCase;

public class MatchRuleTest
extends TestCase {
    public void testStringMatch() {
        StringMatchRule matcher = new StringMatchRule("foo");
        InputState in = new InputState((CharSequence)"bar");
        RegionList regions = new RegionList();
        matcher.process(in, regions);
        MatchRuleTest.assertTrue((in.getOffset() == 0 ? 1 : 0) != 0);
        in = new InputState((CharSequence)"");
        matcher.process(in, regions);
        MatchRuleTest.assertTrue((in.getOffset() == 0 ? 1 : 0) != 0);
        in = new InputState((CharSequence)"foo");
        final Region expectedMatch = new Region(0, 3);
        matcher.setAction(new MatchAction(){

            public boolean perform(InputState input, Map matchRegions, RegionList outputRegions) {
                TestCase.assertTrue((String)("expecting " + expectedMatch + ", got " + matchRegions.get("0")), (boolean)expectedMatch.sameSpan((Region)matchRegions.get("0")));
                TestCase.assertTrue((boolean)input.getSubSequence(expectedMatch).equals("foo"));
                return true;
            }
        });
        matcher.process(in, regions);
        MatchRuleTest.assertTrue((in.getOffset() == 3 ? 1 : 0) != 0);
        try {
            matcher = new StringMatchRule(null);
            MatchRuleTest.fail((String)"expected IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            matcher = new StringMatchRule("");
            MatchRuleTest.fail((String)"expected IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRegexpMatch() {
        RegexpMatchRule matcher = new RegexpMatchRule("foo(\\d*(\\/ +\\/)?)");
        InputState in = new InputState((CharSequence)"bar");
        RegionList regions = new RegionList();
        matcher.process(in, regions);
        MatchRuleTest.assertTrue((in.getOffset() == 0 ? 1 : 0) != 0);
        in = new InputState((CharSequence)"");
        matcher.process(in, regions);
        MatchRuleTest.assertTrue((in.getOffset() == 0 ? 1 : 0) != 0);
        in = new InputState((CharSequence)"foobar");
        matcher.setAction(new MatchAction(){

            public boolean perform(InputState input, Map matchRegions, RegionList outputRegions) {
                Region expectedMatch = new Region(0, 3);
                TestCase.assertTrue((String)("expecting 1, got " + matchRegions.size()), (matchRegions.size() == 1 ? 1 : 0) != 0);
                TestCase.assertTrue((String)("expecting " + expectedMatch + ", got " + matchRegions.get("0")), (boolean)expectedMatch.sameSpan((Region)matchRegions.get("0")));
                TestCase.assertTrue((boolean)input.getSubSequence(expectedMatch).equals("foo"));
                return true;
            }
        });
        matcher.process(in, regions);
        MatchRuleTest.assertTrue((in.getOffset() == 3 ? 1 : 0) != 0);
        in = new InputState((CharSequence)"foo123456789bar");
        matcher.setAction(new MatchAction(){

            public boolean perform(InputState input, Map matchRegions, RegionList outputRegions) {
                Region expectedMatch0 = new Region(0, 12);
                Region expectedMatch1 = new Region(3, 12);
                TestCase.assertTrue((String)("expecting 2, got " + matchRegions.size()), (matchRegions.size() == 2 ? 1 : 0) != 0);
                TestCase.assertTrue((String)("expecting " + expectedMatch0 + ", got " + matchRegions.get("0")), (boolean)expectedMatch0.sameSpan((Region)matchRegions.get("0")));
                TestCase.assertTrue((boolean)input.getSubSequence(expectedMatch0).equals("foo123456789"));
                TestCase.assertTrue((String)("expecting " + expectedMatch1 + ", got " + matchRegions.get("1")), (boolean)expectedMatch1.sameSpan((Region)matchRegions.get("1")));
                TestCase.assertTrue((boolean)input.getSubSequence(expectedMatch1).equals("123456789"));
                return true;
            }
        });
        matcher.process(in, regions);
        MatchRuleTest.assertTrue((in.getOffset() == 12 ? 1 : 0) != 0);
        in = new InputState((CharSequence)"foo123456789/ /bar");
        matcher.setAction(new MatchAction(){

            public boolean perform(InputState input, Map matchRegions, RegionList outputRegions) {
                Region expectedMatch0 = new Region(0, 15);
                Region expectedMatch1 = new Region(3, 15);
                Region expectedMatch2 = new Region(12, 15);
                TestCase.assertTrue((String)("expecting 3, got " + matchRegions.size()), (matchRegions.size() == 3 ? 1 : 0) != 0);
                TestCase.assertTrue((String)("expecting " + expectedMatch0 + ", got " + matchRegions.get("0")), (boolean)expectedMatch0.sameSpan((Region)matchRegions.get("0")));
                TestCase.assertTrue((boolean)input.getSubSequence(expectedMatch0).equals("foo123456789/ /"));
                TestCase.assertTrue((String)("expecting " + expectedMatch1 + ", got " + matchRegions.get("1")), (boolean)expectedMatch1.sameSpan((Region)matchRegions.get("1")));
                TestCase.assertTrue((boolean)input.getSubSequence(expectedMatch1).equals("123456789/ /"));
                TestCase.assertTrue((String)("expecting " + expectedMatch2 + ", got " + matchRegions.get("2")), (boolean)expectedMatch2.sameSpan((Region)matchRegions.get("2")));
                TestCase.assertTrue((boolean)input.getSubSequence(expectedMatch2).equals("/ /"));
                return true;
            }
        });
        matcher.process(in, regions);
        MatchRuleTest.assertTrue((in.getOffset() == 15 ? 1 : 0) != 0);
        try {
            matcher = new RegexpMatchRule(null);
            MatchRuleTest.fail((String)"expected IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            matcher = new RegexpMatchRule("");
            MatchRuleTest.fail((String)"expected IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            matcher = new RegexpMatchRule("***");
            MatchRuleTest.fail((String)"expected IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

