/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.EntityLink;
import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.syntax.SyntaxDefinitionTest;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class LinkerTest
extends TestCase {
    SyntaxDefinition wholeString = SyntaxDefinitionTest.parseSyntaxDef("syntaxdef cf {/.*/m : { region {findlinks=true;}}}");
    SyntaxDefinition bracketed = SyntaxDefinitionTest.parseSyntaxDef("syntaxdef cf {/\\{.*?\\}/m : { region {findlinks=true;}}}");
    Linker linker = new Linker();

    protected void setUp() throws Exception {
        SyntaxDefinition ch = SyntaxDefinitionTest.parseSyntaxDef("syntaxdef cf {/\\b[a-z][a-z][a-z]-\\d+/i : { region {href=blah;}}}");
        this.linker.addHighlighter(ch);
        ch = SyntaxDefinitionTest.parseSyntaxDef("syntaxdef cf {/___/ : { region {href=firstrule; asd=asd;}}}");
        this.linker.addHighlighter(ch);
        ch = SyntaxDefinitionTest.parseSyntaxDef("syntaxdef cf {/___/ : { region {href=secondrule;}}}");
        this.linker.addHighlighter(ch);
        File primaryDir = new File(FisheyeTestEnv.WORKSPACE_DIR, "etc/dist/syntax");
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(primaryDir);
        SyntaxDefinitions sds = new SyntaxDefinitions(dirs);
        this.linker.addHighlighter(sds.getByFileName("url.def"));
    }

    public void testLinker() {
        Map<String, String> m = Collections.singletonMap("href", "blah");
        this.assertRegions(this.wholeString, "fixed bug ABC-123 foo", new Region[]{new Region(10, 17, m)});
        this.assertRegions(this.bracketed, "ABC-123 {foo ABC-44 blah} ABC-1 {ABC-33}", new Region[]{new Region(13, 19, m), new Region(33, 39, m)});
    }

    public void testTwoMatchingLinkers() {
        HashMap<String, String> firstProps = new HashMap<String, String>();
        firstProps.put("href", "firstrule");
        firstProps.put("asd", "asd");
        this.assertRegions(this.wholeString, "some thing ___ blah", new Region[]{new Region(11, 14, firstProps), new Region(11, 14, Collections.singletonMap("href", "secondrule"))});
    }

    public void testUrls() {
        this.assertRegions(this.wholeString, "url http://foo.com/blah.html is woot", new Region[]{new Region(4, 28, Collections.singletonMap("href", "http://foo.com/blah.html"))});
        this.assertRegions(this.wholeString, "url http://foo.com/blah.html#anchor(with,%20Bracket) is woot", new Region[]{new Region(4, 52, Collections.singletonMap("href", "http://foo.com/blah.html#anchor(with,%20Bracket)"))});
        this.assertRegions(this.wholeString, "and http://foo.com/foo/bar_with(parenthesis).txt end", new Region[]{new Region(4, 48, Collections.singletonMap("href", "http://foo.com/foo/bar_with(parenthesis).txt"))});
        this.assertRegions(this.bracketed, "and {see http://foo.com/foo/bar.txt } ABC-1 {ABC-33}", new Region[]{new Region(9, 35, Collections.singletonMap("href", "http://foo.com/foo/bar.txt")), new Region(45, 51, Collections.singletonMap("href", "blah"))});
    }

    public void testAnchorUrls() {
        this.assertRegions(this.wholeString, "url http://foo.com/blah.html#anch is woot", new Region[]{new Region(4, 33, Collections.singletonMap("href", "http://foo.com/blah.html#anch"))});
        this.assertRegions(this.wholeString, "url http://foo.com/blah.html#anch-thing is woot", new Region[]{new Region(4, 39, Collections.singletonMap("href", "http://foo.com/blah.html#anch-thing"))});
    }

    public void testTildeUrls() {
        this.assertRegions(this.wholeString, "url http://domain.com/~site/blah.html is woot", new Region[]{new Region(4, 37, Collections.singletonMap("href", "http://domain.com/~site/blah.html"))});
        this.assertRegions(this.wholeString, "url https://domain.com/~site/extras is woot", new Region[]{new Region(4, 35, Collections.singletonMap("href", "https://domain.com/~site/extras"))});
        this.assertRegions(this.wholeString, "url https://www.domain.com/site/~site is woot", new Region[]{new Region(4, 37, Collections.singletonMap("href", "https://www.domain.com/site/~site"))});
        this.assertRegions(this.wholeString, "url http://domain.com/inter~mitten is woot", new Region[]{new Region(4, 34, Collections.singletonMap("href", "http://domain.com/inter~mitten"))});
        this.assertRegions(this.wholeString, "url http://foo.com/blah.html#ank~or is woot", new Region[]{new Region(4, 35, Collections.singletonMap("href", "http://foo.com/blah.html#ank~or"))});
        this.assertRegions(this.wholeString, "url http://foo.com/blah.html?query~ is win", new Region[]{new Region(4, 35, Collections.singletonMap("href", "http://foo.com/blah.html?query~"))});
    }

    public void testBracketUrls() {
        this.assertRegions(this.wholeString, "url http://www.domain.com/thi(s) is fantastic!", new Region[]{new Region(4, 32, Collections.singletonMap("href", "http://www.domain.com/thi(s)"))});
        this.assertRegions(this.wholeString, "url http://www.domain.com/th(i((s))) is not a dinosaur", new Region[]{new Region(4, 36, Collections.singletonMap("href", "http://www.domain.com/th(i((s)))"))});
        this.assertRegions(this.wholeString, "url http://www.domain.com/this) is around? ", new Region[]{new Region(4, 30, Collections.singletonMap("href", "http://www.domain.com/this"))});
        this.assertRegions(this.wholeString, "url http://www.domain.com/th(i(s)))", new Region[]{new Region(4, 34, Collections.singletonMap("href", "http://www.domain.com/th(i(s))"))});
        this.assertRegions(this.wholeString, "url http://www.domain.com/th(i(()(()s)))", new Region[]{new Region(4, 40, Collections.singletonMap("href", "http://www.domain.com/th(i(()(()s)))"))});
        this.assertRegions(this.wholeString, "url http://www.domain.com/th(i(()(()s))))", new Region[]{new Region(4, 40, Collections.singletonMap("href", "http://www.domain.com/th(i(()(()s)))"))});
        this.assertRegions(this.wholeString, "url http://www.domain.com/th(i(((()s)))", new Region[]{new Region(4, 39, Collections.singletonMap("href", "http://www.domain.com/th(i(((()s)))"))});
        this.assertRegions(this.wholeString, "url http://www.domain.com/th)(is)))", new Region[]{new Region(4, 33, Collections.singletonMap("href", "http://www.domain.com/th)(is)"))});
    }

    public void testJIRALinkers() throws URISyntaxException {
        EntityLink fakeJira = (EntityLink)Mockito.mock(EntityLink.class);
        ApplicationLink fakeAppLink = (ApplicationLink)Mockito.mock(ApplicationLink.class);
        String jiraURL = "http://fake/jira";
        Mockito.when((Object)fakeAppLink.getDisplayUrl()).thenReturn((Object)new URI(jiraURL));
        Mockito.when((Object)fakeJira.getKey()).thenReturn((Object)"ABC");
        Mockito.when((Object)fakeJira.getApplicationLink()).thenReturn((Object)fakeAppLink);
        Linker jiralinker = LinkerFactory.generateJiraSyntaxDef((Collection)Lists.newArrayList((Object[])new EntityLink[]{fakeJira}));
        RegionList inputRegions = new RegionList();
        String jiraTest = "ABC-123 then ABC-345,ABC-678 then [ABC-890] but not CR-ABC-666";
        this.wholeString.generateRegions(new InputState((CharSequence)jiraTest), inputRegions);
        this.assertRegions(new Region[]{new Region(0, 62, Collections.singletonMap("findlinks", "true")), new Region(0, 7, this.expectedJiraProps(jiraURL, "ABC-123")), new Region(13, 20, this.expectedJiraProps(jiraURL, "ABC-345")), new Region(21, 28, this.expectedJiraProps(jiraURL, "ABC-678")), new Region(35, 42, this.expectedJiraProps(jiraURL, "ABC-890"))}, jiraTest, inputRegions, jiralinker);
    }

    private Map<String, String> expectedJiraProps(String jiraURL, String jiraKey) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "jiralink");
        m.put("jiralink", jiraKey);
        m.put("href", jiraURL + "/browse/" + jiraKey);
        return m;
    }

    private void assertRegions(SyntaxDefinition sd, CharSequence input, Region[] expected) {
        RegionList inputRegions = new RegionList();
        sd.generateRegions(new InputState(input), inputRegions);
        this.assertRegions(expected, input, inputRegions, this.linker);
    }

    private void assertRegions(Region[] expected, CharSequence input, RegionList regions, Linker linker) {
        linker.insertLinks(input, regions);
        ArrayList<Region> left = new ArrayList<Region>(Arrays.asList(expected));
        for (Region region : regions) {
            if (!left.isEmpty()) {
                Region top = (Region)left.get(0);
                if (!top.sameSpan(region)) continue;
                LinkerTest.assertEquals((Object)top.getProperties(), (Object)region.getProperties());
                left.remove(0);
                continue;
            }
            LinkerTest.fail((String)("more than expected, next is " + region));
        }
        LinkerTest.assertTrue((String)("left with: " + left), (boolean)left.isEmpty());
    }
}

