/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.io.BufferedCharSequence;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.RandomAccessIOStream;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.junit.Assert;

public class LargeFileTest
extends TestCase {
    public static final String STACK_OVERFLOW_ERROR_OCCURRED_ON_S_FILE = "StackOverflowError occurred on %s file";
    private SyntaxDefinitions sds;

    protected void setUp() throws Exception {
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(new File(FisheyeTestEnv.WORKSPACE_DIR, "etc/dist/syntax"));
        this.sds = new SyntaxDefinitions(dirs);
    }

    private SyntaxDefinitions.ParseResult parseFile(String fileWithPath, String filename) throws FileNotFoundException {
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(new File(FisheyeTestEnv.WORKSPACE_DIR, fileWithPath));
        return this.sds.getRegionsForFile(filename, (CharSequence)new BufferedCharSequence((RandomAccessIOStream)in));
    }

    public void testFE114() throws Exception {
        SyntaxDefinitions.ParseResult result = this.parseFile("test/testfiles/syntax/FE-144_project.xml", "project.xml");
        LargeFileTest.assertFalse((boolean)result.isParserOverflowOccured());
    }

    public void testVeryLargeFile() throws Exception {
        SyntaxDefinitions.ParseResult result = this.parseFile("test/testfiles/syntax/FE-92_FormHelperTest.php", "FormHelperTest.php");
        LargeFileTest.assertFalse((boolean)result.isParserOverflowOccured());
    }

    public void testFE182() throws Exception {
        SyntaxDefinitions.ParseResult result = this.parseFile("test/testfiles/syntax/FE-182_long_string_literal.php", "long_string_literal.php");
        LargeFileTest.assertFalse((boolean)result.isParserOverflowOccured());
    }

    public void testFE5320FilesContainingLongLine() throws Exception {
        this.parseFileFailOnStackOverflow("test/testfiles/syntax/FE-5320-long_line.cs", "FE-5320-long_line.cs");
        this.parseFileFailOnStackOverflow("test/testfiles/syntax/python_test.py", "python_test.py");
        this.parseFileFailOnStackOverflow("test/testfiles/syntax/FE-5320-long_line.vb", "FE-5320-long_line.vb");
        this.parseFileFailOnStackOverflow("test/testfiles/syntax/FE-5320-long_line.pl", "FE-5320-long_line.pl");
    }

    private void parseFileFailOnStackOverflow(String fileWithPath, String filename) throws FileNotFoundException {
        try {
            SyntaxDefinitions.ParseResult result = this.parseFile(fileWithPath, filename);
            LargeFileTest.assertFalse((String)String.format(STACK_OVERFLOW_ERROR_OCCURRED_ON_S_FILE, filename), (boolean)result.isParserOverflowOccured());
        }
        catch (StackOverflowError error) {
            Assert.fail((String)String.format(STACK_OVERFLOW_ERROR_OCCURRED_ON_S_FILE, filename));
        }
    }

    public void testFE237() throws Exception {
        String[] extns;
        for (String ext : extns = new String[]{"php"}) {
            System.out.println("ext = " + ext);
            SyntaxDefinitions.ParseResult result = this.parseFile("test/testfiles/syntax/FE-237_bad_php_begin.php", "bad_php_begin." + ext);
            LargeFileTest.assertFalse((boolean)result.isParserOverflowOccured());
        }
    }

    public void testHTMLSyntaxHighlighting() throws FileNotFoundException {
        SyntaxDefinitions.ParseResult result = this.parseFile("test/testfiles/syntax/FE-237_html_syntax_test.html", "html_syntax_test.html");
        LargeFileTest.assertFalse((boolean)result.isParserOverflowOccured());
    }

    public void testJavascriptRegexHighlightingStackOverflow() throws FileNotFoundException {
        SyntaxDefinitions.ParseResult result = this.parseFile("test/testfiles/syntax/FE-521_javascript_regex_highlight_stackoverflow.js", "FE-521_javascript_regex_highlight_stackoverflow.js");
        LargeFileTest.assertFalse((boolean)result.isParserOverflowOccured());
    }
}

