/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.SyntaxTestBase;
import org.junit.Test;

public class JavaSyntaxTest
extends SyntaxTestBase {
    @Test
    public void strictfpLexed() {
        this.assertRegions("strictfp class Foo {}", 0, 8, "keyword", 9, 14, "keyword", 15, 18, "identifier");
    }

    @Test
    public void strictfpInStringLexed() {
        this.assertRegions("String s = \"strictfp\";", 0, 6, "identifier", 7, 8, "identifier", 11, 21, "string");
    }

    @Test
    public void enumLexed() {
        this.assertRegions("enum Foo {}", 0, 4, "keyword", 5, 8, "identifier");
    }

    @Test
    public void enumInStringLexed() {
        this.assertRegions("String s = \"enum\";", 0, 6, "identifier", 7, 8, "identifier", 11, 17, "string");
    }

    @Test
    public void assertLexed() {
        this.assertRegions("assert true;", 0, 6, "keyword", 7, 11, "keyword");
    }

    @Test
    public void assertInStringLexed() {
        this.assertRegions("String s = \"assert\";", 0, 6, "identifier", 7, 8, "identifier", 11, 19, "string");
    }

    @Test
    public void binaryNumLiteralsLexed() {
        this.assertRegions("int i = 0b010101010;", 0, 3, "keyword", 4, 5, "identifier", 8, 19, "numeric");
        this.assertRegions("int i = 0b010101010L;", 0, 3, "keyword", 4, 5, "identifier", 8, 20, "numeric");
    }

    @Test
    public void binaryNumInStringLiteralsLexed() {
        this.assertRegions("String s = \"0b010101010\";", 0, 6, "identifier", 7, 8, "identifier", 11, 24, "string");
    }

    @Test
    public void numLiteralsWithUnderscoresLexed() {
        this.assertRegions("int i = 0b0__101_010_10;", 0, 3, "keyword", 4, 5, "identifier", 8, 23, "numeric");
        this.assertRegions("long l = 0b0__101_010_10L;", 0, 4, "keyword", 5, 6, "identifier", 9, 25, "numeric");
        this.assertRegions("int i = 0xa_b_cdef;", 0, 3, "keyword", 4, 5, "identifier", 8, 18, "numeric");
        this.assertRegions("long l = 0xa_b_cdefL;", 0, 4, "keyword", 5, 6, "identifier", 9, 20, "numeric");
        this.assertRegions("double d = 0_0.0_0f;", 0, 6, "keyword", 7, 8, "identifier", 11, 19, "numeric");
        this.assertRegions("double d = 0_0.0_0d;", 0, 6, "keyword", 7, 8, "identifier", 11, 19, "numeric");
        this.assertRegions("double d = .0_0d;", 0, 6, "keyword", 7, 8, "identifier", 11, 16, "numeric");
        this.assertRegions("double d = .0_0e1_0d;", 0, 6, "keyword", 7, 8, "identifier", 11, 20, "numeric");
    }

    @Override
    protected String getDummyFileName() {
        return "Foo.java";
    }
}

