/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Region;
import junit.framework.TestCase;

public class InputStateTest
extends TestCase {
    public void testInputState() {
        InputState in = new InputState((CharSequence)"foobar");
        InputStateTest.assertTrue((boolean)in.hasMoreChars());
        InputStateTest.assertTrue((boolean)in.getRemainingChars().equals("foobar"));
        InputStateTest.assertTrue((in.length() == 6 ? 1 : 0) != 0);
        InputStateTest.assertTrue((in.getOffset() == 0 ? 1 : 0) != 0);
        in.consume();
        InputStateTest.assertTrue((boolean)in.hasMoreChars());
        InputStateTest.assertTrue((boolean)in.getRemainingChars().equals("oobar"));
        InputStateTest.assertTrue((in.length() == 6 ? 1 : 0) != 0);
        InputStateTest.assertTrue((in.getOffset() == 1 ? 1 : 0) != 0);
        CharSequence seq1 = in.getSubSequence(3, 6);
        CharSequence seq2 = in.getSubSequence(new Region(3, 6));
        InputStateTest.assertTrue((boolean)seq1.equals(seq2));
        InputStateTest.assertTrue((boolean)seq1.equals("bar"));
        in.consume(2);
        InputStateTest.assertTrue((in.getOffset() == 3 ? 1 : 0) != 0);
        InputStateTest.assertTrue((boolean)in.hasMoreChars());
        InputStateTest.assertTrue((boolean)in.getRemainingChars().equals("bar"));
        in.consume(3);
        InputStateTest.assertFalse((boolean)in.hasMoreChars());
        in = new InputState((CharSequence)"foobar");
        for (int i = 0; i < 6; ++i) {
            in.consume();
        }
        InputStateTest.assertFalse((boolean)in.hasMoreChars());
        in = new InputState((CharSequence)"foobar");
        in.consume(6);
        InputStateTest.assertFalse((boolean)in.hasMoreChars());
        try {
            in.consume();
            InputStateTest.fail((String)"Expecting ISE");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            in.consume(20);
            InputStateTest.fail((String)"Expecting ISE");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

