/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.JavaSyntaxTest;
import org.junit.Test;

public class GroovySyntaxTest
extends JavaSyntaxTest {
    @Test
    public void keywordsAreLexed() {
        String[] KEYWORDS;
        for (String keyword : KEYWORDS = new String[]{"abstract", "as", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "def", "default", "double", "else", "extends", "enum", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "threadsafe", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"}) {
            this.assertRegions(keyword, 0, keyword.length(), "keyword");
        }
    }

    @Test
    public void singleLineCommentsAreLexed() {
        this.assertRegions("// foo bar", 0, 10, "comment");
    }

    @Test
    public void multiLineCommentsAreLexed() {
        this.assertRegions("/* foo \n\n bar */", 0, 16, "comment", 2, 14, this.kvp("index", "prose"));
    }

    @Test
    public void slashyStringsAreLexed() {
        this.assertRegions("/abc/", 0, 5, "regex");
        this.assertRegions("/ab\n\nc/", 0, 7, "regex");
        this.assertRegions("$/a\n\nbc/$", 0, 9, "regex");
    }

    @Test
    public void multilineStringsAreLexed() {
        this.assertRegions("\"\"\"ab\n\nc\"\"\"", 0, 11, "string");
    }

    @Test
    public void annotationAreLexed() {
        this.assertRegions("@Foo", 0, 4, "annotation");
    }

    @Test
    public void identifiersAreLexed() {
        this.assertRegions("foo = bar", 0, 3, "identifier", 6, 9, "identifier");
    }

    @Test
    public void bigHunkOGroovyCodeIsLexed() {
        this.assertRegions("public class Foo {\n/* foo\n   //bar \n */\n\tdef blah = \"\"\"\n\tone\n\ttwo\n\tthree\n\t\"\"\"\n\t\n\t// match yyyy-mm-dd from this or previous century\n\tdef dateRegex = /(?x)     # enable whitespace and comments\n\t((?:19|20)\\d\\d)           # year (group 1) (non-capture alternation for century)\n\t-                         # seperator\n\t(0[1-9]|1[012])           # month (group 2)\n\t-                         # seperator\n\t(0[1-9]|[12][0-9]|3[01])  # day (group 3)\n\t/\n\t\n\tdef dollarSlashy = $/\n\t    Hello $name,\n\t    today we're $date\n\t    $ dollar-sign\n\t    $$ dollar-sign\n\t    \\ backslash\n\t    / slash\n\t    $/ slash\n\t/$\n\t\n\tdef tic = 'tic'\n\n\tdef xml = $/\n\t  <xml>\n\t  $tic\\tac\n\t  </xml>\n\t/$\n\n\tassert \"\\n<xml>\\ntic\\\\tac\\n</xml>\\n\" == xml\n\t\n\tdef dir = $/C:\\temp\\/$\n\t\n\t// match yyyy-mm-dd from current or previous century\n\tdef dateRegex = $/(?x)    # enable whitespace and comments\n\t((?:19|20)\\d\\d)           # year (group 1) (non-capture alternation for century)\n\t[- /.]                    # seperator\n\t(0[1-9]|1[012])           # month (group 2)\n\t[- /.]                    # seperator\n\t(0[1-9]|[12][0-9]|3[01])  # day (group 3)\n\t/$\n\n\tassert '04/04/1988' == '1988-04-04'.find(dateRegex) { all, y, m, d -> [d, m, y].join('/') }\n\tassert '10-08-1989' == '1989/08/10'.find(dateRegex) { all, y, m, d -> [d, m, y].join('-') }\n\t\n\tdef alphabet = ('a'..'z').join('')\n\tdef code = $/\n\t    def normal = '\\b\\t\\n\\r'\n\t    def slashy = /\\b\\t\\n\\r/\n\t    assert '$alphabet'.size() == 26\n\t    assert normal.size() == 4\n\t    assert slashy.size() == 8\n\t/$\n\tprintln code\n\tEval.me(code)\n}", 0, 6, this.kvp("index", "word", "type", "keyword"), 7, 12, this.kvp("index", "word", "type", "keyword"), 13, 16, this.kvp("index", "word", "type", "identifier"), 19, 39, this.kvp("findlinks", "true", "type", "comment"), 21, 37, this.kvp("index", "prose"), 41, 44, this.kvp("index", "word", "type", "keyword"), 45, 49, this.kvp("index", "word", "type", "identifier"), 52, 77, "string", 81, 130, this.kvp("findlinks", "true", "index", "prose", "type", "comment"), 132, 135, this.kvp("index", "word", "type", "keyword"), 136, 145, this.kvp("index", "word", "type", "identifier"), 148, 441, "regex", 445, 448, this.kvp("index", "word", "type", "keyword"), 449, 461, this.kvp("index", "word", "type", "identifier"), 464, 594, "regex", 598, 601, this.kvp("index", "word", "type", "keyword"), 602, 605, this.kvp("index", "word", "type", "identifier"), 608, 613, this.kvp("type", "string"), 616, 619, this.kvp("index", "word", "type", "keyword"), 620, 623, this.kvp("index", "word", "type", "identifier"), 626, 663, "regex", 666, 672, this.kvp("index", "word", "type", "keyword"), 673, 702, this.kvp("type", "string"), 706, 709, this.kvp("index", "word", "type", "identifier"), 713, 716, this.kvp("index", "word", "type", "keyword"), 717, 720, this.kvp("index", "word", "type", "identifier"), 723, 735, "regex", 739, 791, this.kvp("findlinks", "true", "index", "prose", "type", "comment"), 793, 796, this.kvp("index", "word", "type", "keyword"), 797, 806, this.kvp("index", "word", "type", "identifier"), 809, 1103, "regex", 1106, 1112, this.kvp("index", "word", "type", "keyword"), 1113, 1125, this.kvp("type", "string"), 1129, 1141, this.kvp("type", "string"), 1142, 1146, this.kvp("index", "word", "type", "identifier"), 1147, 1156, this.kvp("index", "word", "type", "identifier"), 1160, 1163, this.kvp("index", "word", "type", "identifier"), 1165, 1166, this.kvp("index", "word", "type", "identifier"), 1168, 1169, this.kvp("index", "word", "type", "identifier"), 1171, 1172, this.kvp("index", "word", "type", "identifier"), 1177, 1178, this.kvp("index", "word", "type", "identifier"), 1180, 1181, this.kvp("index", "word", "type", "identifier"), 1183, 1184, this.kvp("index", "word", "type", "identifier"), 1186, 1190, this.kvp("index", "word", "type", "identifier"), 1191, 1194, this.kvp("type", "string"), 1199, 1205, this.kvp("index", "word", "type", "keyword"), 1206, 1218, this.kvp("type", "string"), 1222, 1234, this.kvp("type", "string"), 1235, 1239, this.kvp("index", "word", "type", "identifier"), 1240, 1249, this.kvp("index", "word", "type", "identifier"), 1253, 1256, this.kvp("index", "word", "type", "identifier"), 1258, 1259, this.kvp("index", "word", "type", "identifier"), 1261, 1262, this.kvp("index", "word", "type", "identifier"), 1264, 1265, this.kvp("index", "word", "type", "identifier"), 1270, 1271, this.kvp("index", "word", "type", "identifier"), 1273, 1274, this.kvp("index", "word", "type", "identifier"), 1276, 1277, this.kvp("index", "word", "type", "identifier"), 1279, 1283, this.kvp("index", "word", "type", "identifier"), 1284, 1287, this.kvp("type", "string"), 1294, 1297, this.kvp("index", "word", "type", "keyword"), 1298, 1306, this.kvp("index", "word", "type", "identifier"), 1310, 1313, this.kvp("type", "string"), 1315, 1318, this.kvp("type", "string"), 1320, 1324, this.kvp("index", "word", "type", "identifier"), 1325, 1327, this.kvp("type", "string"), 1330, 1333, this.kvp("index", "word", "type", "keyword"), 1334, 1338, this.kvp("index", "word", "type", "identifier"), 1341, 1504, "regex", 1506, 1513, this.kvp("index", "word", "type", "identifier"), 1514, 1518, this.kvp("index", "word", "type", "identifier"), 1520, 1524, this.kvp("index", "word", "type", "identifier"), 1525, 1527, this.kvp("index", "word", "type", "identifier"), 1528, 1532, this.kvp("index", "word", "type", "identifier"));
    }

    @Override
    protected String getDummyFileName() {
        return "Foo.groovy";
    }
}

