/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.atlassian.crucible.fisheye.CrucibleProjectHighlighter;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.web.admin.actions.jira.DummyProjectManager;
import junit.framework.TestCase;

public class CrucibleHighlighterTest
extends TestCase {
    private String reviewId;
    private ProjectManager projectManager = new DummyProjectManager();

    protected void setUp() {
        this.reviewId = this.projectManager.getNextPermaId(new Project(), new Review()).toString();
    }

    public void testLinking() throws Exception {
        CrucibleProjectHighlighter highlighter = new CrucibleProjectHighlighter(this.projectManager, (ReviewManager)new DefaultReviewManager(null, null, null, null, null, null, null, null, null, null, null, null, (TxTemplate)new DummyTxTemplate()){

            public boolean reviewExists(String permaId) {
                return permaId.equals(CrucibleHighlighterTest.this.reviewId);
            }
        }, new RootConfig(){

            public String getSiteURL() {
                return "http://mysite/";
            }
        });
        RegionList regionList = new RegionList();
        highlighter.generateRegions(new InputState((CharSequence)(this.reviewId + " CR-2 CR-3")), regionList);
        CrucibleHighlighterTest.assertEquals((int)1, (int)regionList.size());
        Region r = (Region)regionList.iterator().next();
        CrucibleHighlighterTest.assertEquals((int)0, (int)r.getStart());
        CrucibleHighlighterTest.assertEquals((int)4, (int)r.getEnd());
        CrucibleHighlighterTest.assertTrue((boolean)r.getPropertyValue("href").endsWith("cru/" + this.reviewId));
        CrucibleHighlighterTest.assertEquals((String)"crulink", (String)r.getPropertyValue("type"));
    }
}

