/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.util;

import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2Scanner;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.xmlbeans.XmlException;
import org.junit.rules.ExternalResource;

public class SvnTestHarnessRule
extends ExternalResource {
    protected SvnTestHarness testHarness;

    protected void after() {
        try {
            this.cleanUpTestHarness();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not clean test harness", e);
        }
        super.after();
    }

    private void cleanUpTestHarness() throws Exception {
        if (this.testHarness != null) {
            this.testHarness.cleanUp();
            this.testHarness = null;
        }
    }

    public Svn2Cache slurp(SvnTestHarness.SvnBuilder harnessBuilder) throws Exception {
        Preconditions.checkState((this.testHarness == null ? 1 : 0) != 0, (Object)"Test harness already initialized in this scope. ");
        return this.doSlurp(harnessBuilder);
    }

    private Svn2Cache doSlurp(SvnTestHarness.SvnBuilder harnessBuilder) throws IOException, RepositoryClientException, ConfigException, XmlException {
        this.testHarness = (SvnTestHarness)harnessBuilder.build();
        return (Svn2Cache)((Svn2Scanner)this.testHarness.getScanner()).getCache();
    }

    public SvnTestHarness getTestHarness() {
        return this.testHarness;
    }
}

