/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.util;

import com.cenqua.fisheye.svn.util.SvnRepositoryPathUtil;
import com.cenqua.fisheye.util.OsUtils;
import junit.framework.Assert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class SvnRepositoryPathUtilTest {
    @Mock
    private OsUtils osUtilsMock;

    @Test
    public void testNormalizeUrl() {
        SvnRepositoryPathUtil svnRepositoryPathUtil = new SvnRepositoryPathUtil();
        Assert.assertEquals((String)"trailing slash not stripped", (String)"foo", (String)svnRepositoryPathUtil.normalizeURL("foo/"));
        Assert.assertEquals((String)"file:// should be assumed for unix file paths", (String)"file:///foo", (String)svnRepositoryPathUtil.normalizeURL("/foo"));
        Assert.assertEquals((String)"file:// should be assumed for unix file paths, trailing slash should be stripped", (String)"file:///foo", (String)svnRepositoryPathUtil.normalizeURL("/foo/"));
    }

    @Test
    public void testNormalizeUrl_shouldLowerCaseDriveLetterInLocalUrlsOnWindows() {
        Mockito.when((Object)this.osUtilsMock.isWindows()).thenReturn((Object)true);
        SvnRepositoryPathUtil svnRepositoryPathUtil = new SvnRepositoryPathUtil(this.osUtilsMock);
        MatcherAssert.assertThat((Object)svnRepositoryPathUtil.normalizeURL("http://C:"), (Matcher)CoreMatchers.equalTo((Object)"http://C:"));
        MatcherAssert.assertThat((Object)svnRepositoryPathUtil.normalizeURL("file://c:/foo/bar"), (Matcher)CoreMatchers.equalTo((Object)"file://c:/foo/bar"));
        MatcherAssert.assertThat((Object)svnRepositoryPathUtil.normalizeURL("file://C:/foo/bar"), (Matcher)CoreMatchers.equalTo((Object)"file://c:/foo/bar"));
        MatcherAssert.assertThat((Object)svnRepositoryPathUtil.normalizeURL("file://C:/d:/foo/bar"), (Matcher)CoreMatchers.equalTo((Object)"file://c:/d:/foo/bar"));
        MatcherAssert.assertThat((Object)svnRepositoryPathUtil.normalizeURL("file://D:/foo/bar"), (Matcher)CoreMatchers.equalTo((Object)"file://d:/foo/bar"));
    }

    @Test
    public void testNormalizeUrl_shouldNotLowerCaseDriveLetterInLocalUrlsOnNonWindows() {
        Mockito.when((Object)this.osUtilsMock.isWindows()).thenReturn((Object)false);
        SvnRepositoryPathUtil svnRepositoryPathUtil = new SvnRepositoryPathUtil(this.osUtilsMock);
        MatcherAssert.assertThat((Object)svnRepositoryPathUtil.normalizeURL("file://C:/foo/bar"), (Matcher)CoreMatchers.equalTo((Object)"file://C:/foo/bar"));
    }
}

