/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.util;

import com.cenqua.fisheye.svn.util.SvnLibraryState;
import com.cenqua.fisheye.svn.util.SvnLoaderConfiguration;
import org.apache.subversion.javahl.types.Version;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SvnLoaderConfigurationTest {
    @Test
    public void testIsSvnkit_forMeaningfullState() throws Exception {
        this.testIsSvnkitForState(SvnLibraryState.SVNKIT, true);
        this.testIsSvnkitForState(SvnLibraryState.NATIVE_FAILED, true);
        this.testIsSvnkitForState(SvnLibraryState.NATIVE_OLD, true);
        this.testIsSvnkitForState(SvnLibraryState.NATIVE, false);
    }

    @Test
    public void testIsSvnkit_forUnknownState() throws Exception {
        String nativeJar = "/usr/lib/svn-javahl/svn-javahl.jar";
        String nativeVersion = "1.8.9 (r1591380)";
        String svnkitJar = "lib/nonmaven-dependencies/svnkit/svnkit-javahl16-1.8.6-r10271_t20140430_1645.jar";
        String svnkitVersion = "SVNKit 1.8.6-r10271_t20140430_1645";
        this.testIsSvnkitForStateVersionLocation(SvnLibraryState.UNKNOWN, nativeVersion, nativeJar, false);
        this.testIsSvnkitForStateVersionLocation(SvnLibraryState.CLASSPATH, nativeVersion, nativeJar, false);
        this.testIsSvnkitForStateVersionLocation(SvnLibraryState.UNKNOWN, svnkitVersion, svnkitJar, true);
        this.testIsSvnkitForStateVersionLocation(SvnLibraryState.CLASSPATH, svnkitVersion, svnkitJar, true);
    }

    private void testIsSvnkitForState(SvnLibraryState state, boolean expectedAnswer) throws Exception {
        this.testIsSvnkitForStateVersionLocation(state, "", "", expectedAnswer);
    }

    private void testIsSvnkitForStateVersionLocation(SvnLibraryState state, String version, String location, boolean expectedAnswer) throws Exception {
        SvnLoaderConfiguration configuration = new SvnLoaderConfiguration();
        configuration.setLibraryState(state);
        configuration.setLocation(location);
        Version svnVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)svnVersion.toString()).thenReturn((Object)version);
        configuration.setVersion(svnVersion);
        Assert.assertThat((Object)configuration.isSvnkit(), (Matcher)Matchers.is((Object)expectedAnswer));
    }
}

