/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.atlassian.fisheye.svn.Svn2Scanner;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import junit.framework.Assert;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.types.Revision;
import org.junit.Test;

public class UpdateRevPropTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/basic.dump";
    }

    @Test
    public void testUpdate() throws DbException, ClientException, RepositoryClientException, ISO8601DateHelper.InvalidDateException, LicensePolicyException {
        Path path = new Path((CharSequence)"trunk/test.txt");
        RevInfoKey key = new RevInfoKey(path, "8");
        RevInfoKey prevKey = new RevInfoKey(path, "6");
        Svn2RepositoryEngine engine = this.getEngine();
        Svn2Scanner scanner = (Svn2Scanner)engine.getScanner();
        SvnScmConfig svnConfig = (SvnScmConfig)engine.getCfg().getScmConfig();
        String repoURL = svnConfig.getRepoUrl();
        SVNClient client = new SVNClient();
        SvnChangeSet changeSet = this.cache.getChangeSet(key.getRev());
        long originalDate = changeSet.getDate();
        FileRevision rev = this.cache.getFileRevision(key);
        String newComment = "Updated comment";
        client.setRevProperty(repoURL, "svn:log", (Revision)new Revision.Number(8L), newComment, null, true);
        scanner.updateRevisions("8", "8");
        rev = this.cache.getFileRevision(key);
        Assert.assertEquals((String)"Incorrect rev level updated comment", (String)newComment, (String)rev.getComment());
        changeSet = this.cache.getChangeSet("8");
        Assert.assertEquals((String)"Incorrect updated comment", (String)newComment, (String)changeSet.getComment());
        String newAuthor = "tony";
        client.setRevProperty(repoURL, "svn:author", (Revision)new Revision.Number(8L), newAuthor, null, true);
        scanner.updateRevisions("8", "8");
        rev = this.cache.getFileRevision(key);
        Assert.assertEquals((String)"Incorrect updated author", (String)newAuthor, (String)rev.getAuthor());
        changeSet = this.cache.getChangeSet("8");
        Assert.assertEquals((String)"Incorrect updated author", (String)newAuthor, (String)changeSet.getAuthor());
        Assert.assertEquals((String)"date updated without being set", (long)originalDate, (long)changeSet.getDate());
        String newDateString = "2005-07-20T08:48:35.046875Z";
        long newDate = ISO8601DateHelper.parseAsUTC((String)newDateString).getTime();
        client.setRevProperty(repoURL, "svn:date", (Revision)new Revision.Number(8L), newDateString, null, true);
        scanner.updateRevisions("8", "8");
        rev = this.cache.getFileRevision(key);
        Assert.assertEquals((String)"Incorrect updated date", (long)newDate, (long)rev.getDate());
    }
}

