/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.svn.diff.SvnDiffListener;
import com.cenqua.fisheye.util.diff.SectionSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestSvnDiffListener
implements SvnDiffListener {
    private Map<Path, FileRecord> records = new HashMap<Path, FileRecord>();

    public FileRecord getRecord(Path path) {
        return this.records.get(path);
    }

    public void indexMark(Path path) {
        if (this.records.containsKey(path)) {
            throw new RuntimeException("Duplicated path " + path);
        }
        this.records.put(path, new FileRecord());
    }

    public void section(Path path, SectionSpec spec, long changeSetId) {
        this.records.get(path).addFileSection(spec);
    }

    public void fromHeader(Path path, String fromHeader) {
        this.records.get(path).setFromHeader(fromHeader);
    }

    public void toHeader(Path path, String toHeader) {
        this.records.get(path).setToHeader(toHeader);
    }

    public void addLine(Path path, String line) {
        this.records.get(path).addAddedLine(line);
    }

    public void contextLine(Path path, String line) {
        this.records.get(path).addContextLine(line);
    }

    public void removeLine(Path path, String line) {
        throw new RuntimeException("Not implemented");
    }

    public void propertyIndexMark(Path path) {
        this.records.get(path).propertyIndexMark();
    }

    public void updateProperty(Path path, String name, String value) {
    }

    public void removeProperty(Path path, String name, String value) {
    }

    public void endSection() {
    }

    public void endFile() {
    }

    public void appendProperty(Path path, String propertyName, String value) {
    }

    public static class FileRecord {
        private String fromHeader;
        private String toHeader;
        private boolean propertyIndexMarkSeen;
        private List<SectionSpec> fileSections = new ArrayList<SectionSpec>();
        private List<String> contextLines = new ArrayList<String>();
        private List<String> addedLines = new ArrayList<String>();

        public void setFromHeader(String fromHeader) {
            this.fromHeader = fromHeader;
        }

        public void setToHeader(String toHeader) {
            this.toHeader = toHeader;
        }

        public void propertyIndexMark() {
            this.propertyIndexMarkSeen = true;
        }

        public void addFileSection(SectionSpec fileSection) {
            this.fileSections.add(fileSection);
        }

        public void addContextLine(String line) {
            this.contextLines.add(line);
        }

        public void addAddedLine(String line) {
            this.addedLines.add(line);
        }

        public boolean isPropertyIndexMarkSeen() {
            return this.propertyIndexMarkSeen;
        }
    }
}

