/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.Test;

public class TagTreeTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/tags.dump";
    }

    @Test
    public void testTagRendering() throws DbException {
        FileRevision rev = this.getFileRevision("/trunk/dir/test2.txt", 2L);
        Path[] paths = this.cache.listDirs(new Path((CharSequence)"/tags/tag1"));
        Assert.assertEquals((String)"Incorrect number of dirs found", (int)1, (int)paths.length);
        HashSet<Path> pathSet = new HashSet<Path>(Arrays.asList(paths));
        Assert.assertTrue((String)"Did not find the directory dir in the list", (boolean)pathSet.contains(new Path((CharSequence)"/tags/tag1/dir")));
        paths = this.cache.listFiles(new Path((CharSequence)"/tags/tag1"));
        Assert.assertEquals((String)"Incorrect number of files found", (int)1, (int)paths.length);
        Assert.assertEquals((String)"Did not find the test.txt in the list", (Object)paths[0], (Object)new Path((CharSequence)"/tags/tag1/test.txt"));
        paths = this.cache.listFiles(new Path((CharSequence)"/tags/tag1/dir"));
        Assert.assertEquals((String)"Incorrect number of files found", (int)1, (int)paths.length);
        Assert.assertEquals((String)"Did not find the test2.txt in the list", (Object)paths[0], (Object)new Path((CharSequence)"/tags/tag1/dir/test2.txt"));
    }
}

