/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import junit.framework.Assert;
import org.junit.Test;

public class TagSrcTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/tagsrc.dump";
    }

    @Test
    public void testTagAsBranchSource() throws Exception {
        SvnRevInfoDAO dao = this.cache.getFileRevisionDAO();
        long latestCSID = dao.getLatestPathChange(new Path((CharSequence)"/branches/br1/dir1/test2.txt"));
        Assert.assertEquals((String)"The tag to branch path was not copied correctly, csid incorrect", (long)4L, (long)latestCSID);
    }

    @Test
    public void testTagAsTrunkSource() throws Exception {
        SvnRevInfoDAO dao = this.cache.getFileRevisionDAO();
        long latestCSID = dao.getLatestPathChange(new Path((CharSequence)"/trunk/new1/dir1/test2.txt"));
        Assert.assertEquals((String)"The tag to trunk path was not copied correctly, csid incorrect", (long)5L, (long)latestCSID);
    }

    @Test
    public void testBranchAsTrunkSource() throws Exception {
        SvnRevInfoDAO dao = this.cache.getFileRevisionDAO();
        long latestCSID = dao.getLatestPathChange(new Path((CharSequence)"/trunk/new2/dir1/test2.txt"));
        Assert.assertEquals((String)"The branch to trunk path was not copied correctly, csid incorrect", (long)6L, (long)latestCSID);
    }
}

