/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import junit.framework.Assert;
import org.junit.Test;

public class TagModifyTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/tagmodify.dump";
    }

    @Test
    public void testModifyOnTag() throws DbException {
        FileRevision rev = this.cache.getFileRevision(new RevInfoKey(new Path((CharSequence)"tags/tag1/dir1/dir2/dir3/test.txt"), "4"));
        Assert.assertNotNull((String)"Unable to find modification in tagged area", (Object)rev);
        Path[] tree = this.cache.listDirs(new Path((CharSequence)"tags/tag2"));
        Assert.assertEquals((String)"tags/tag2 not returned in dir listing", (int)1, (int)tree.length);
        Assert.assertEquals((String)"dir1 not found in tags2", (Object)new Path((CharSequence)"tags/tag2/dir1"), (Object)tree[0]);
        tree = this.cache.listFiles(new Path((CharSequence)"tags/tag2/dir1/dir2/dir3"));
        Assert.assertEquals((String)"tag2 test.txt directory not returned", (int)1, (int)tree.length);
        Assert.assertEquals((String)"test.txt not found", (Object)new Path((CharSequence)"tags/tag2/dir1/dir2/dir3/test.txt"), (Object)tree[0]);
        rev = this.cache.getFileRevision(new RevInfoKey(new Path((CharSequence)"tags/tag3/dir1/dir2/dir3/test.txt"), "6"));
        Assert.assertNotNull((String)"Unable to find modification in tagged area", (Object)rev);
        Assert.assertEquals((String)"tag rev not found", (String)"6", (String)rev.getRevision());
        tree = this.cache.listDirs(new Path((CharSequence)"tags/tag3"));
        Assert.assertEquals((String)"tags/tag3 not returned in dir listing", (int)1, (int)tree.length);
        Assert.assertEquals((String)"dir1 not found in tag3", (Object)new Path((CharSequence)"tags/tag3/dir1"), (Object)tree[0]);
        tree = this.cache.listFiles(new Path((CharSequence)"tags/tag3/dir1/dir2/dir3"));
        Assert.assertEquals((String)"tag3 test.txt directory not returned", (int)1, (int)tree.length);
        Assert.assertEquals((String)"test.txt not found", (Object)new Path((CharSequence)"tags/tag3/dir1/dir2/dir3/test.txt"), (Object)tree[0]);
        FileHistory history = this.cache.getFileHistory(new Path((CharSequence)"tags/tag3/dir1/dir2/dir3/test.txt"));
        FisheyeTestUtil.drawHistory(history);
    }
}

