/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.google.common.collect.ImmutableList;
import org.junit.Assert;

abstract class SvnWithExcludedFilesTestBase
extends SvnTestBase {
    SvnWithExcludedFilesTestBase() {
    }

    @Override
    protected AllowType getAllowRules() {
        AllowType allow = AllowType.Factory.newInstance();
        allow.addNewExclude().setPattern("**/excluded_file*");
        return allow;
    }

    static void assertAddedFileWithNewLines(FileRevision fileRevision, int lineCount, int linesAdded) {
        Assert.assertTrue((boolean)fileRevision.isAdded());
        Assert.assertEquals((long)lineCount, (long)fileRevision.getLineCount());
        Assert.assertEquals((long)linesAdded, (long)fileRevision.getLinesAdded());
        Assert.assertEquals((long)0L, (long)fileRevision.getLinesRemoved());
        Assert.assertEquals((Object)ImmutableList.of((Object)new Hunk(0, 1, 0, linesAdded)), (Object)fileRevision.getHunks());
    }

    static void assertRemovedFile(FileRevision fileRevision, int linesRemoved) {
        Assert.assertTrue((boolean)fileRevision.isDead());
        Assert.assertEquals((long)0L, (long)fileRevision.getLinesAdded());
        Assert.assertEquals((long)linesRemoved, (long)fileRevision.getLinesRemoved());
        Assert.assertEquals((long)0L, (long)fileRevision.getLineCount());
        Assert.assertEquals((Object)ImmutableList.of((Object)new Hunk(1, 0, linesRemoved, 0)), (Object)fileRevision.getHunks());
    }
}

