/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fecru.upgrade.DefaultUpgradeManager;
import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.pipeline.ChangeSetPhaseQueues;
import com.atlassian.fisheye.pipeline.ChangeSetPipeline;
import com.atlassian.fisheye.pipeline.ChangeSetProcessor;
import com.atlassian.fisheye.pipeline.DefaultChangeSetPipeline;
import com.atlassian.fisheye.pipeline.PartitionedChangeSetPhaseQueues;
import com.atlassian.fisheye.pipeline.PipelinePhase;
import com.atlassian.fisheye.rep.BaseTestHarness;
import com.atlassian.fisheye.rep.ScannerTestHarness;
import com.atlassian.fisheye.scmapi.ScmConfig;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2ContentProcessor;
import com.atlassian.fisheye.svn.Svn2MetadataProcessor;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.atlassian.fisheye.svn.Svn2Scanner;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringProcessHandler;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.SafeExternalProcessBuilder;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.RepositorySystemType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.util.SvnLoader;
import com.cenqua.fisheye.util.CustomFileNameMap;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.SVNRepos;
import org.apache.xmlbeans.XmlException;
import org.mockito.Mockito;

public class SvnTestHarness
extends ScannerTestHarness<Svn2RepositoryEngine, Svn2Scanner> {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final Phase DEFAULT_STOP_INDEXING_AT_PHASE = Phase.WRAPUP;
    private SvnSymbolicType symbolicDefinition;
    private long startRev;
    private boolean doInitialImport;
    private boolean followBaseMove;
    private String charset = "UTF-8";
    private Phase stopIndexingAtPhase = DEFAULT_STOP_INDEXING_AT_PHASE;

    @Deprecated
    public SvnTestHarness() {
        Logger svnkitLogger = Logger.getLogger("svnkit");
        svnkitLogger.setLevel(Level.ALL);
        CustomFileNameMap fileNameMap = new CustomFileNameMap(false);
        Mockito.when((Object)this.rootConfig.getRawMimeMap()).thenReturn((Object)fileNameMap);
        this.setFlagWarnings(true);
        AppConfig.setTestMode();
    }

    @Override
    protected void startRepo() throws RepositoryClientException, ConfigException {
        SvnLoader.checkLoaded();
    }

    @Override
    protected Svn2RepositoryEngine createEngine() throws XmlException, IOException, ConfigException, DbException {
        RepositoryType repoDef = this.createSvnRepoDefinition();
        PhaseSvnScmConfig svnConfig = new PhaseSvnScmConfig(repoDef.getName(), this.getRootConfig(), (RepositorySystemType)repoDef.getSvn());
        RepositoryConfig config = this.createRepositoryConfig(repoDef, svnConfig);
        UpgradeManager upgradeManager = DefaultUpgradeManager.getInstance();
        return (Svn2RepositoryEngine)config.createRepositoryEngine(upgradeManager, this.getIndexingContext());
    }

    protected RepositoryConfig createRepositoryConfig(RepositoryType repoDef, SvnScmConfig svnConfig) {
        return new RepositoryConfig(this.getRootConfig(), repoDef, (ScmConfig)svnConfig, (LicenseEnforcer)new NullLicenseEnforcer(), null);
    }

    @Override
    protected RepositoryHandle createMockRepoHandle() {
        RepositoryHandle handle = super.createMockRepoHandle();
        Mockito.when((Object)handle.isPipelined()).thenReturn((Object)true);
        return handle;
    }

    @Override
    protected DefaultChangeSetPipeline createChangeSetPipeline() {
        if (this.isPhaseAllowed(Phase.INFILL)) {
            DefaultChangeSetPipeline changeSetPipeline = new DefaultChangeSetPipeline((ChangeSetPhaseQueues)new PartitionedChangeSetPhaseQueues(new File(AppConfig.getCacheDir(), "pipeline"), false), this.getEventPublisher());
            changeSetPipeline.init();
            return changeSetPipeline;
        }
        return null;
    }

    private boolean isPhaseAllowed(Phase phase) {
        return this.stopIndexingAtPhase.isAtOrAfter(phase);
    }

    private void registerChangesetProcessor(ChangeSetPipeline pipeline, PipelinePhase phase, ChangeSetProcessor processor, RepositoryHandle handle, int workers) {
        pipeline.registerPhaseProcessor(phase, entry -> processor.processChangesetEntry(handle, entry), workers);
    }

    @Override
    protected void registerChangesetProcessors(ChangeSetPipeline pipeline, RepositoryHandle handle) {
        this.registerChangesetProcessor(pipeline, PipelinePhase.METADATA, (ChangeSetProcessor)new Svn2MetadataProcessor(), handle, 4);
        this.registerChangesetProcessor(pipeline, PipelinePhase.INDEXING, (ChangeSetProcessor)new Svn2ContentProcessor(), handle, 4);
    }

    private void createAndLoad(File dumpFile, File repoDirPath) {
        SVNRepos admin = new SVNRepos();
        try {
            admin.create(repoDirPath, true, false, null, "fsfs");
            FileInputStream fis = new FileInputStream(dumpFile);
            InputStream inputStream = dumpFile.getName().endsWith(".gz") ? new GZIPInputStream(fis) : fis;
            admin.load(repoDirPath, inputStream, true, false, true, true, null, System.out::println);
        }
        catch (ClientException e) {
            throw new RuntimeException("Unable to create and load SVN repo", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException reading dump: " + dumpFile, e);
        }
    }

    @Override
    protected void restoreDump(File dumpLocation, File repoLocation) throws IOException {
        this.createAndLoad(dumpLocation, repoLocation);
        File hooksDir = new File(repoLocation, "hooks");
        if (File.separatorChar == '\\') {
            File scriptFile = new File(hooksDir, "pre-revprop-change.bat");
            if (scriptFile.exists()) {
                scriptFile.delete();
            }
            scriptFile.createNewFile();
            IOHelper.copyStringToFile((String)"cls", (Charset)Charsets.UTF_8, (File)scriptFile);
        } else {
            File scriptFile = new File(hooksDir, "pre-revprop-change");
            if (scriptFile.exists()) {
                scriptFile.delete();
            }
            IOHelper.copyStringToFile((String)"#!/bin/sh\nexit 0\n", (Charset)Charsets.UTF_8, (File)scriptFile);
            this.makeExecutable(scriptFile);
        }
    }

    protected String getRepoURL() {
        return "file://" + this.getRepoDir().getAbsolutePath().replace('\\', '/');
    }

    private void makeExecutable(File scriptFile) {
        StringProcessHandler handler = new StringProcessHandler();
        ExternalProcess extProcess = new SafeExternalProcessBuilder().command(Arrays.asList("chmod", "+x", scriptFile.getAbsolutePath())).handler((ProcessHandler)handler).build();
        extProcess.execute();
        if (!handler.succeeded()) {
            throw new RuntimeException("Unable to chmod the svn rev prop hook");
        }
    }

    private RepositoryType createSvnRepoDefinition() {
        String repoPath = this.getSubPath() == null ? "" : this.getSubPath();
        RepositoryType repoDefinition = this.createRepoDefinition();
        SvnRepType svn = repoDefinition.addNewSvn();
        svn.setUrl(this.getRepoURL());
        svn.setPath(repoPath);
        if (this.symbolicDefinition != null) {
            svn.setSymbolic(this.symbolicDefinition);
        }
        if (this.startRev > 0L) {
            svn.setStartRev(BigInteger.valueOf(this.startRev));
            if (this.doInitialImport) {
                svn.setInitialImport("notags");
            } else {
                svn.setInitialImport("none");
            }
        }
        if (this.getBlockSize() > 0L) {
            svn.setBlocksize(BigInteger.valueOf(this.getBlockSize()));
        }
        svn.setFollowBase(this.followBaseMove);
        svn.setCharset(this.charset);
        return repoDefinition;
    }

    public void setSymbolicDefinition(SvnSymbolicType symbolDef) {
        this.symbolicDefinition = symbolDef;
    }

    public void setStartRev(long startRev) {
        this.startRev = startRev;
    }

    public void setDoInitialImport(boolean doInitialImport) {
        this.doInitialImport = doInitialImport;
    }

    public void setFollowBaseMove(boolean followBaseMove) {
        this.followBaseMove = followBaseMove;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setStopIndexingAtPhase(Phase stopIndexingAtPhase) {
        this.stopIndexingAtPhase = stopIndexingAtPhase;
    }

    public static SvnBuilder builder() {
        return new SvnBuilder();
    }

    static /* synthetic */ Phase access$100() {
        return DEFAULT_STOP_INDEXING_AT_PHASE;
    }

    public static class Builder {
        private String subPath;
        private SvnSymbolicType symbolicDefinition;
        private long startRev;
        private boolean doInitialImport;
        private long blockSize;
        private AllowType allowType;

        public Builder setSubPath(String subPath) {
            this.subPath = subPath;
            return this;
        }

        public Builder setSymbolicDefinition(SvnSymbolicType symbolicDefinition) {
            this.symbolicDefinition = symbolicDefinition;
            return this;
        }

        public Builder setStartRev(long startRev) {
            this.startRev = startRev;
            return this;
        }

        public Builder setDoInitialImport(boolean initImport) {
            this.doInitialImport = initImport;
            return this;
        }

        public Builder setBlockSize(long blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder setAllowType(AllowType allowType) {
            this.allowType = allowType;
            return this;
        }

        public SvnTestHarness build() {
            SvnTestHarness testHarness = new SvnTestHarness();
            testHarness.setSubPath(this.subPath);
            testHarness.setSymbolicDefinition(this.symbolicDefinition);
            testHarness.setStartRev(this.startRev);
            testHarness.setDoInitialImport(this.doInitialImport);
            testHarness.setBlockSize(this.blockSize);
            testHarness.setAllow(this.allowType);
            return testHarness;
        }
    }

    public static class SvnBuilder
    extends BaseTestHarness.BaseBuilder<SvnBuilder, SvnTestHarness> {
        private SvnSymbolicType symbolicDefinition;
        private long startRev;
        private boolean doInitialImport;
        private boolean followBaseMove;
        private Phase stopIndexingAtPhase = SvnTestHarness.access$100();
        private String charset = "UTF-8";

        public SvnBuilder setSymbolicDefinition(SvnSymbolicType symbolicDefinition) {
            this.symbolicDefinition = symbolicDefinition;
            return (SvnBuilder)this.builder();
        }

        public SvnBuilder setStartRev(long startRev) {
            this.startRev = startRev;
            return (SvnBuilder)this.builder();
        }

        public SvnBuilder setDoInitialImport(boolean doInitialImport) {
            this.doInitialImport = doInitialImport;
            return (SvnBuilder)this.builder();
        }

        public SvnBuilder setFollowBaseMove(boolean followBaseMove) {
            this.followBaseMove = followBaseMove;
            return (SvnBuilder)this.builder();
        }

        public SvnBuilder setCharset(String charset) {
            this.charset = charset;
            return (SvnBuilder)this.builder();
        }

        public SvnBuilder setStopIndexingAtPhase(Phase stopIndexingAtPhase) {
            this.stopIndexingAtPhase = stopIndexingAtPhase;
            return (SvnBuilder)this.builder();
        }

        @Override
        protected SvnTestHarness createHarness() {
            return new SvnTestHarness();
        }

        @Override
        protected SvnTestHarness configureTestHarness(SvnTestHarness testHarness) {
            testHarness.setSymbolicDefinition(this.symbolicDefinition);
            testHarness.setStartRev(this.startRev);
            testHarness.setDoInitialImport(this.doInitialImport);
            testHarness.setFollowBaseMove(this.followBaseMove);
            testHarness.setCharset(this.charset);
            testHarness.setStopIndexingAtPhase(this.stopIndexingAtPhase);
            return testHarness;
        }
    }

    class PhaseSvn2Scanner
    extends Svn2Scanner {
        protected PhaseSvn2Scanner(Svn2RepositoryEngine engine) throws ConfigException {
            super(engine);
        }

        protected void infillRepository(long timeLimitMillis) throws RepositoryClientException, IOException, LicensePolicyException {
            if (SvnTestHarness.this.isPhaseAllowed(Phase.INFILL)) {
                super.infillRepository(timeLimitMillis);
            }
        }

        protected void wrapupRepository(long timeLimitMillis, RepositoryStatus status, Svn2Cache cache, long lastCSID) {
            if (SvnTestHarness.this.isPhaseAllowed(Phase.WRAPUP)) {
                super.wrapupRepository(timeLimitMillis, status, cache, lastCSID);
            }
        }
    }

    class PhaseSvn2RepositoryEngine
    extends Svn2RepositoryEngine {
        public PhaseSvn2RepositoryEngine(RepositoryConfig config, UpgradeManager upgradeManager, IndexingContext indexingContext) {
            super(config, upgradeManager, indexingContext);
        }

        protected Svn2Scanner createScanner() throws DbException, ConfigException {
            return new PhaseSvn2Scanner(this);
        }
    }

    class PhaseSvnScmConfig
    extends SvnScmConfig {
        public PhaseSvnScmConfig(String name, RootConfig rootConfig, RepositorySystemType scmConfig) {
            super(name, rootConfig, scmConfig);
        }

        public RepositoryEngine createRepositoryEngine(RepositoryConfig repoConfig, UpgradeManager upgradeManager, IndexingContext indexingContext) {
            return new PhaseSvn2RepositoryEngine(repoConfig, upgradeManager, indexingContext);
        }
    }

    public static enum Phase {
        SCAN,
        INFILL,
        WRAPUP;


        public boolean isAtOrAfter(Phase phase) {
            return this.compareTo(phase) >= 0;
        }
    }
}

