/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2FileHistory;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.atlassian.fisheye.svn.Svn2Scanner;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.cenqua.fisheye.svn.util.SvnSymbolics;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.xmlbeans.XmlException;
import org.junit.After;
import org.junit.Before;

public abstract class SvnTestBase {
    protected Svn2Cache cache;
    protected SvnTestHarness testHarness;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.checkCleanStart();
        try {
            AppConfig.setTestMode();
            Logs.APP_LOG.setLevel(Level.DEBUG);
            Logs.setConsoleLevel((Priority)Level.DEBUG);
            this.testHarness = this.createHarness();
            String dumpFile = this.getDumpFile();
            if (dumpFile != null) {
                File dump = this.findDump(dumpFile);
                this.configureTestHarness(this.testHarness);
                this.testHarness.slurpDump(dump);
                this.testHarness.assertNoSlurpErrors(dumpFile);
                this.cache = (Svn2Cache)((Svn2Scanner)this.testHarness.getScanner()).getCache();
            }
        }
        finally {
            if (this.cache == null) {
                this.tearDown();
            }
        }
    }

    protected File findDump(String dumpFile) {
        File dump = new File(FisheyeTestEnv.WORKSPACE_DIR, dumpFile);
        if (!dump.exists()) {
            File dumpsDir = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/svn/dumps/");
            dump = new File(dumpsDir, dumpFile);
            if (!dump.exists()) {
                dump = new File(dumpsDir, dumpFile + ".dump");
            }
            if (!dump.exists()) {
                throw new IllegalStateException("Dump file " + dumpFile + " could not be found");
            }
        }
        return dump;
    }

    public void doIncSlurp(String dumpFile) throws ConfigException, RepositoryClientException, XmlException, IOException {
        this.testHarness.doIncSlurp(this.findDump(dumpFile));
    }

    protected SvnTestHarness createHarness() {
        return new SvnTestHarness();
    }

    protected void configureTestHarness(SvnTestHarness testHarness) {
        testHarness.setSubPath(this.getSubPath());
        testHarness.setSymbolicDefinition(this.getPathMatcher());
        testHarness.setStartRev(this.getStartRev());
        testHarness.setDoInitialImport(this.getDoInitialImport());
        testHarness.setBlockSize(2L);
        testHarness.setAllow(this.getAllowRules());
    }

    protected boolean getDoInitialImport() {
        return true;
    }

    protected long getStartRev() {
        return 0L;
    }

    @After
    public void tearDown() throws Exception {
        if (this.testHarness != null) {
            this.testHarness.cleanUp();
            this.testHarness = null;
        }
        TestFishEyeInstances.checkCleanStart();
    }

    protected abstract String getDumpFile();

    protected AllowType getAllowRules() {
        return null;
    }

    protected SvnSymbolicType getPathMatcher() {
        return SvnSymbolics.defaultRules();
    }

    protected String getSubPath() {
        return null;
    }

    protected void assertContainsRevs(String query, int expectedSize, int[] requiredChangeSetIds) throws Exception {
        SearchResults collator = this.testHarness.evaluateQuery(query);
        FisheyeTestUtil.assertSearchResults(collator, expectedSize, query, requiredChangeSetIds);
    }

    protected Map<String, FileRevision> runSearch(String query) throws Exception {
        SearchResults collator = this.testHarness.evaluateQuery(query);
        SearchResults.RevisionResultsIterator results = collator.iterateRevisions(0);
        HashMap<String, FileRevision> revs = new HashMap<String, FileRevision>();
        while (results.hasNext()) {
            FileRevision rev = results.nextItem();
            revs.put(rev.getChangeSetId(), rev);
        }
        return revs;
    }

    protected FileRevision getFileRevision(String path, long rev) {
        return this.cache.getFileRevision(new RevInfoKey(new Path((CharSequence)path), Long.toString(rev)));
    }

    protected Svn2FileHistory getFileHistory(String path) {
        return (Svn2FileHistory)this.cache.getFileHistory(new Path((CharSequence)path));
    }

    public Svn2Cache getCache() {
        return this.cache;
    }

    public SvnTestHarness getTestHarness() {
        return this.testHarness;
    }

    public Svn2RepositoryEngine getEngine() {
        return (Svn2RepositoryEngine)this.getTestHarness().getEngine();
    }

    public SearchResults evaluateQuery(String query) throws Exception {
        return this.getTestHarness().evaluateQuery(query);
    }
}

