/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class SvnStartTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/start.dump";
    }

    @Override
    protected long getStartRev() {
        return 5L;
    }

    @Test
    public void testLineCounts() throws DbException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"trunk/test.txt"), "7");
        FileRevision revision = this.cache.getFileRevision(key);
        Assert.assertEquals((String)"Lines added is incorrect", (int)1, (int)revision.getLinesAdded());
    }

    @Test
    public void testBlame() throws IOException, DbException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"trunk/test.txt"), "7");
        Blame blame = this.cache.getBlame(key);
        Assert.assertEquals((String)"Blame chunk count incorrect", (int)3, (int)blame.getChunks().size());
    }

    @Test
    public void testDirCreation() throws IOException, DbException {
        Assert.assertTrue((String)"expected dir1 to be a dir", (boolean)this.cache.isDir(new Path((CharSequence)"trunk/dir1")));
    }
}

