/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.svn.SvnTestBase;
import junit.framework.Assert;
import org.junit.Test;

public class SvnSearchTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/search.dump";
    }

    @Test
    public void testAuthorSearch() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions from dir /trunk where author = \"tester\"");
        int size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        SearchResults.RevisionResultsIterator results = collator.iterateRevisions(0);
        FileRevision rev = results.nextItem();
        Assert.assertEquals((String)"Incorrect revision returned", (String)"3", (String)rev.getChangeSetId());
        collator = this.evaluateQuery("select revisions from dir /trunk where author = \"conor\"");
        size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)2, (int)size);
        this.assertResultContains(collator, "trunk", "1");
        this.assertResultContains(collator, "trunk/test.txt", "2");
    }

    @Test
    public void testP4SpecificTestEmpty() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions from dir /trunk where p4:jobid = \"blah\"");
        int size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)size);
        collator = this.evaluateQuery("select revisions where p4:jobid = \"JFEP-123\" or comment =~ 'JFEP-[0-9]+'");
        size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)size);
    }

    private void assertResultContains(SearchResults collator, String path, String rev) throws Exception {
        SearchResults.RevisionResultsIterator i = collator.iterateRevisions(0);
        while (i.hasNext()) {
            FileRevision fi = i.nextItem();
            if (!fi.getPath().getPath().equals(path) || !fi.getRevision().equals(rev) || !fi.getChangeSetId().equals(rev)) continue;
            return;
        }
        Assert.fail((String)("Could not find " + path + " " + rev));
    }

    @Test
    public void testCommentMatch() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions from dir /trunk where comment matches \"Updated\"");
        int size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        FileRevision rev = collator.iterateRevisions(0).nextItem();
        Assert.assertEquals((String)"Incorrect revision returned", (String)"3", (String)rev.getChangeSetId());
    }

    @Test
    public void testCommentExactMatch() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions from dir /trunk where comment = \"Updated with second\"");
        int size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        FileRevision rev = collator.iterateRevisions(0).nextItem();
        Assert.assertEquals((String)"Incorrect revision returned", (String)"3", (String)rev.getChangeSetId());
    }

    @Test
    public void testNotClause() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions from dir /trunk where not comment = \"Updated with second\"");
        int size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)3, (int)size);
    }

    @Test
    public void testCommentRegexMatch() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions from dir /trunk where comment =~ \"Upd[at][at]ed.*\"");
        int size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        FileRevision rev = collator.iterateRevisions(0).nextItem();
        Assert.assertEquals((String)"Incorrect revision returned", (String)"3", (String)rev.getChangeSetId());
    }

    @Test
    public void testSimpleDateSearch() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions from dir / where date > 2005-08-08T16:36:00+1000");
        int size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)2, (int)size);
        FileRevision rev = collator.iterateRevisions(0).nextItem();
        Assert.assertEquals((String)"Incorrect revision returned", (String)"3", (String)rev.getChangeSetId());
    }

    @Test
    public void testRangeDateSearch() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions from dir / where date > 2005-08-08T16:35:00+1000 and date < 2005-08-08T16:36:00+1000");
        int size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        FileRevision rev = collator.iterateRevisions(0).nextItem();
        Assert.assertEquals((String)"Incorrect revision returned", (String)"2", (String)rev.getChangeSetId());
    }

    @Test
    public void testNoDir() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions where comment matches \"Updated\"");
        int size = collator.size();
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)size);
        FileRevision rev = collator.iterateRevisions(0).nextItem();
        Assert.assertEquals((String)"Incorrect revision returned", (String)"3", (String)rev.getChangeSetId());
    }

    @Test
    public void testLimit_Duration() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions limit 0");
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)collator.size());
        collator = this.evaluateQuery("select revisions limit 1");
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)collator.size());
        SearchResults.RevisionResultsIterator resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)1, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 3");
        Assert.assertEquals((String)"Result set incorrect size", (int)3, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)1, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)2, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)3, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 6");
        Assert.assertEquals((String)"Result set incorrect size", (int)6, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)1, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)2, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)3, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)4, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)5, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)6, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 60000");
        Assert.assertEquals((String)"Result set incorrect size", (int)7, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)1, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)2, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)3, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)4, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)5, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)6, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)7, (int)resultsIterator.nextItem().getRevID());
    }

    @Test
    public void testLimit_Duration_Offset_Offset() throws Exception {
        SearchResults collator = this.evaluateQuery("select revisions limit 0 offset 0");
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)collator.size());
        collator = this.evaluateQuery("select revisions limit 0 offset 4");
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)collator.size());
        collator = this.evaluateQuery("select revisions limit 1 offset 0");
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)collator.size());
        SearchResults.RevisionResultsIterator resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)1, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 1 offset 3");
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)4, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 2 offset 3");
        Assert.assertEquals((String)"Result set incorrect size", (int)2, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)4, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)5, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 6 offset 0");
        Assert.assertEquals((String)"Result set incorrect size", (int)6, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)1, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)2, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)3, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)4, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)5, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)6, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 10 offset 7");
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)collator.size());
        collator = this.evaluateQuery("select revisions limit 60000 offset 0");
        Assert.assertEquals((String)"Result set incorrect size", (int)7, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)1, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)2, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)3, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)4, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)5, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)6, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)7, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 60000 offset 60000");
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)collator.size());
    }

    @Test
    public void testLimit_Offset_Comma_Duration() throws Exception {
        SearchResults test = this.evaluateQuery("select revisions order by date desc");
        SearchResults.RevisionResultsIterator testIt = test.iterateRevisions(0);
        FileRevision revision0 = testIt.nextItem();
        FileRevision revision1 = testIt.nextItem();
        FileRevision revision2 = testIt.nextItem();
        FileRevision revision3 = testIt.nextItem();
        FileRevision revision4 = testIt.nextItem();
        FileRevision revision5 = testIt.nextItem();
        System.out.println(revision0.getDate());
        System.out.println(revision1.getDate());
        System.out.println(revision2.getDate());
        System.out.println(revision3.getDate());
        System.out.println(revision4.getDate());
        System.out.println(revision5.getDate());
        SearchResults collator = this.evaluateQuery("select revisions limit 0,0");
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)collator.size());
        collator = this.evaluateQuery("select revisions limit 4 , 0");
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)collator.size());
        collator = this.evaluateQuery("select revisions limit 0, 1");
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)collator.size());
        SearchResults.RevisionResultsIterator resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)1, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 3 ,1");
        Assert.assertEquals((String)"Result set incorrect size", (int)1, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)4, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions order by date asc limit 2,4");
        Assert.assertEquals((String)"Result set incorrect size", (int)4, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)3, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)4, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)5, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)6, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions order by date desc limit 0,3");
        Assert.assertEquals((String)"Result set incorrect size", (int)3, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)7, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)6, (int)resultsIterator.nextItem().getRevID());
        int thirdResult = resultsIterator.nextItem().getRevID();
        Assert.assertTrue((String)"Incorrect revision returned", (thirdResult >= 1 && thirdResult <= 5 ? 1 : 0) != 0);
        collator = this.evaluateQuery("select revisions limit 0, 6");
        Assert.assertEquals((String)"Result set incorrect size", (int)6, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)1, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)2, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)3, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)4, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)5, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)6, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 7, 10");
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)collator.size());
        collator = this.evaluateQuery("select revisions limit 0, 60000");
        Assert.assertEquals((String)"Result set incorrect size", (int)7, (int)collator.size());
        resultsIterator = collator.iterateRevisions(0);
        Assert.assertEquals((String)"Incorrect revision returned", (int)1, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)2, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)3, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)4, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)5, (int)resultsIterator.nextItem().getRevID());
        Assert.assertEquals((String)"Incorrect revision returned", (int)6, (int)resultsIterator.nextItem().getRevID());
        collator = this.evaluateQuery("select revisions limit 60000, 60000");
        Assert.assertEquals((String)"Result set incorrect size", (int)0, (int)collator.size());
    }
}

