/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.event.CommitEventImpl;
import com.atlassian.fisheye.event.RepositoryScanProcessedEvent;
import com.atlassian.fisheye.rep.RepositoryEventCollector;
import com.cenqua.fisheye.rep.BranchChange;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SvnRepositoryScanProcessedEventTest
extends SvnTestBase {
    private RepositoryEventCollector eventCollector = new RepositoryEventCollector();

    @Override
    protected SvnTestHarness createHarness() {
        return new SvnTestHarness(){

            @Override
            protected void beforeEngineStarted() {
                super.beforeEngineStarted();
                this.registerCommitEventGenerator();
                this.getEventPublisher().register((Object)SvnRepositoryScanProcessedEventTest.this.eventCollector);
            }
        };
    }

    @Override
    protected String getDumpFile() {
        return "scanprocessed-step1.dump";
    }

    @Test
    public void testScanProcessedEvent() throws Exception {
        List<Object> eventsAfterInitial = this.eventCollector.getAndClearEvents();
        this.getTestHarness().setPipelineCompletionWaitTime(0L);
        this.doIncSlurp("scanprocessed-step2.dump");
        List<Object> eventsAfterIncremental = this.eventCollector.getAndClearEvents();
        this.doIncSlurp("scanprocessed-step2.dump");
        List<Object> eventsAfterSubsequent = this.eventCollector.getAndClearEvents();
        Assert.assertThat(eventsAfterInitial, (Matcher)Matchers.empty());
        Assert.assertThat(eventsAfterIncremental, (Matcher)Matchers.contains((Object[])new Object[]{new CommitEventImpl(this.getEngine().getName(), "3"), new RepositoryScanProcessedEvent(this.getEngine().getName(), Collections.singleton("3"), (Iterable)ImmutableSet.of((Object)new BranchChange("branch1", BranchChange.ChangeType.MODIFIED), (Object)new BranchChange("branch2", BranchChange.ChangeType.ADDED)))}));
        Assert.assertThat(eventsAfterSubsequent, (Matcher)Matchers.empty());
    }
}

