/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.content.ContentResult;
import com.atlassian.fecru.search.content.ContentSearcher;
import com.atlassian.fecru.search.diffs.DiffResult;
import com.atlassian.fecru.search.diffs.DiffSearcher;
import com.atlassian.fecru.search.filepaths.FilePathSearcher;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SvnQuicksearchTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/search.dump";
    }

    @Test
    public void testFilePathSearcher() throws Exception {
        RepositoryManager repositoryManager = (RepositoryManager)Mockito.mock(RepositoryManager.class);
        Mockito.when((Object)repositoryManager.getHandleMap()).thenReturn(Collections.emptyMap());
        Svn2RepositoryEngine engine = this.getEngine();
        FilePathSearcher searcher = new FilePathSearcher(repositoryManager, engine.getCrossRepLuceneIndex());
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{this.getTestHarness().createMockRepoHandle()}).build();
        Assert.assertEquals((int)1, (int)searcher.search("test.txt", scope).getTotalCount());
        Assert.assertEquals((int)1, (int)searcher.search("branches", scope).getTotalCount());
        Assert.assertEquals((int)1, (int)searcher.search("tags", scope).getTotalCount());
        Assert.assertEquals((int)0, (int)searcher.search("file1", scope).getTotalCount());
    }

    @Test
    public void testDiffTextSearcher() throws Exception {
        DiffSearcher searcher = new DiffSearcher();
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{this.getTestHarness().createMockRepoHandle()}).build();
        SearchResults diffResults = searcher.search("initial", scope);
        Assert.assertEquals((int)2, (int)diffResults.getTotalCount());
        Iterator it = diffResults.iterator();
        Assert.assertTrue((boolean)((DiffResult.DiffFile)((DiffResult)it.next()).getFiles().get(0)).getHighlightedAddedText().contains("initial"));
        Assert.assertTrue((boolean)((DiffResult.DiffFile)((DiffResult)it.next()).getFiles().get(0)).getHighlightedRemovedText().contains("initial"));
    }

    @Test
    public void testContentSearcher() throws Exception {
        ContentSearcher searcher = new ContentSearcher();
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{this.getTestHarness().createMockRepoHandle()}).build();
        SearchResults contentResults = searcher.search("initial", scope);
        Assert.assertEquals((int)0, (int)contentResults.getTotalCount());
        contentResults = searcher.search("another", scope);
        Assert.assertEquals((int)1, (int)contentResults.getTotalCount());
        Assert.assertTrue((boolean)((ContentResult)contentResults.iterator().next()).getHighlightedContent().contains("another"));
    }
}

