/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.SpringIntegrationTestBase;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2FileHistory;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;

public class SvnOversizeTest
extends SpringIntegrationTestBase {
    public static final String DUMP_FILE = "test/testfiles/svn/dumps/oversize.dump";

    public static void assertRevisionsATxt(Svn2Cache cache, int numExpectedRevisionsA, String path) throws DbException {
        Svn2FileHistory history = cache.getFileHistory(new Path((CharSequence)path), false);
        List revs = history.getRevisionsSorted();
        TestCase.assertEquals((int)revs.size(), (int)numExpectedRevisionsA);
        for (FileRevision rev : revs) {
            TestCase.assertFalse((boolean)rev.isOversize());
        }
    }

    public static void assertRevisionsBTxt(Svn2Cache cache, int numExpectedRevisionsB, String path) throws DbException {
        Svn2FileHistory history = cache.getFileHistory(new Path((CharSequence)path), false);
        List revs = history.getRevisionsSorted();
        TestCase.assertEquals((int)revs.size(), (int)numExpectedRevisionsB);
        for (FileRevision rev : revs) {
            if ("5".equals(rev.getRevision())) {
                SvnOversizeTest.assertRevision(rev, false, 3, 3, 0);
                continue;
            }
            if ("6".equals(rev.getRevision())) {
                SvnOversizeTest.assertRevision(rev, true, 0, 0, 3);
                continue;
            }
            SvnOversizeTest.assertRevision(rev, true, 0, 0, 0);
        }
    }

    private static void assertRevision(FileRevision rev, boolean oversize, int linecount, int linesAdded, int linesRemoved) {
        String s = "Revision " + rev.getPath() + "@" + rev.getRevision() + "(revid = " + rev.getRevID() + ")";
        TestCase.assertEquals((String)s, (boolean)oversize, (boolean)rev.isOversize());
        TestCase.assertEquals((String)s, (int)rev.getLineCount(), (int)linecount);
        TestCase.assertEquals((String)s, (int)rev.getLinesAdded(), (int)linesAdded);
        TestCase.assertEquals((String)s, (int)rev.getLinesRemoved(), (int)linesRemoved);
    }

    @Test
    public void testNormal() throws Exception {
        Normal normal = new Normal();
        normal.runTest();
    }

    @Test
    public void testExclude() throws Exception {
        Exclude exclude = new Exclude();
        exclude.runTest();
    }

    @Test
    public void testSubPath() throws Exception {
        SubPath base = new SubPath();
        base.runTest();
    }

    @Test
    public void testStartRevWithImport() throws Exception {
        StartRevWithImport base = new StartRevWithImport();
        base.runTest();
    }

    public static class StartRevWithImport
    extends Base {
        StartRevWithImport() {
            super(4, 7);
        }

        @Override
        protected long getStartRev() {
            return 2L;
        }

        @Override
        protected boolean getDoInitialImport() {
            return true;
        }
    }

    public static class StartRevNoImport
    extends Base {
        StartRevNoImport() {
            super(3, 6);
        }

        @Override
        protected long getStartRev() {
            return 2L;
        }

        @Override
        protected boolean getDoInitialImport() {
            return false;
        }
    }

    private static class SubPath
    extends Base {
        SubPath() {
            super(2, 5, "branch1/A.txt", "branch1/B.txt");
        }

        @Override
        public String getSubPath() {
            return "branches";
        }
    }

    private static class Exclude
    extends Base {
        Exclude() {
            super(2, 5);
        }

        @Override
        protected AllowType getAllowRules() {
            AllowType allow = AllowType.Factory.newInstance();
            allow.addNewExclude().setPattern("/trunk");
            return allow;
        }
    }

    public static class Normal
    extends Base {
        Normal() {
            super(4, 7);
        }
    }

    public static abstract class Base
    extends SvnTestBase {
        int numExpectedRevisionsA;
        int numExpectedRevisionsB;
        String pathA = "trunk/A.txt";
        String pathB = "trunk/B.txt";

        Base(int numExpectedRevisionsA, int numExpectedRevisionsB) {
            this.numExpectedRevisionsA = numExpectedRevisionsA;
            this.numExpectedRevisionsB = numExpectedRevisionsB;
        }

        Base(int numExpectedRevisionsA, int numExpectedRevisionsB, String pathA, String pathB) {
            this.numExpectedRevisionsA = numExpectedRevisionsA;
            this.numExpectedRevisionsB = numExpectedRevisionsB;
            this.pathA = pathA;
            this.pathB = pathB;
        }

        @Override
        protected String getDumpFile() {
            return SvnOversizeTest.DUMP_FILE;
        }

        public void runTest() throws Exception {
            try {
                this.setUp();
                SvnOversizeTest.assertRevisionsATxt(this.cache, this.numExpectedRevisionsA, this.pathA);
                SvnOversizeTest.assertRevisionsBTxt(this.cache, this.numExpectedRevisionsB, this.pathB);
            }
            finally {
                this.tearDown();
            }
        }
    }
}

