/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import org.junit.Assert;
import org.junit.Test;

public class SvnMimeTypeChangeTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/FSH-7842-svn-binary-not-annotatable.dump";
    }

    @Test
    public void testBinaryAndAnnotatableFlags() {
        FileHistory fileHistory = this.cache.getFileHistory(new Path((CharSequence)"trunk/some-file.sql"));
        FileRevision rev2 = fileHistory.getRevision("2");
        FileRevision rev3 = fileHistory.getRevision("3");
        FileRevision rev4 = fileHistory.getRevision("4");
        Assert.assertNotNull((Object)rev2);
        Assert.assertTrue((String)"Revision 2 should be marked as binary", (boolean)rev2.isBinary());
        Assert.assertFalse((String)"Revision 2 should not be annotatable", (boolean)rev2.isAnnotatable());
        Assert.assertNotNull((Object)rev3);
        Assert.assertFalse((String)"Revision 3 should be marked as text", (boolean)rev3.isBinary());
        Assert.assertTrue((String)"Revision 3 should be annotatable", (boolean)rev3.isAnnotatable());
        Assert.assertNotNull((Object)rev4);
        Assert.assertFalse((String)"Revision 4 should be marked as text", (boolean)rev4.isBinary());
        Assert.assertTrue((String)"Revision 4 should  be annotatable", (boolean)rev4.isAnnotatable());
    }
}

