/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnPathRule;
import com.cenqua.fisheye.web.admin.actions.svn.SvnSymbolicHelper;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.junit.Test;

public class SvnLogicalPathMatcherTest {
    @Test
    public void testSvnLogicalMatcherEquals() {
        SvnLogicalPathMatcher matcher1 = this.createOneLevelMatcher();
        SvnLogicalPathMatcher matcher2 = this.createOneLevelMatcher();
        SvnLogicalPathMatcher matcher3 = this.createMultiLevelMatcher();
        SvnLogicalPathMatcher matcher4 = this.createMultiLevelMatcher();
        Assert.assertTrue((boolean)matcher1.equals((Object)matcher1));
        Assert.assertTrue((boolean)matcher1.equals((Object)matcher2));
        Assert.assertTrue((boolean)matcher2.equals((Object)matcher1));
        Assert.assertTrue((boolean)matcher2.equals((Object)matcher2));
        Assert.assertTrue((boolean)matcher3.equals((Object)matcher3));
        Assert.assertTrue((boolean)matcher3.equals((Object)matcher4));
        Assert.assertTrue((boolean)matcher4.equals((Object)matcher3));
        Assert.assertTrue((boolean)matcher4.equals((Object)matcher4));
        Assert.assertFalse((boolean)matcher3.equals((Object)matcher1));
        Assert.assertFalse((boolean)matcher3.equals((Object)matcher2));
        Assert.assertFalse((boolean)matcher4.equals((Object)matcher1));
        Assert.assertFalse((boolean)matcher4.equals((Object)matcher2));
    }

    @Test
    public void testOneLevelScheme() {
        SvnLogicalPathMatcher m = this.createOneLevelMatcher();
        SvnLogicalPathMatcherTest.assertMatch(m, "foo.txt", null, null, null, null);
        SvnLogicalPathMatcherTest.assertMatch(m, "trunk/foo.txt", "trunk", null, null, "foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "trunk/bar/foo.txt", "trunk", null, null, "bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "branches/BR123/foo.txt", null, "BR123", null, "foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "branches/BR123/bar/foo.txt", null, "BR123", null, "bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "tags/TAG1/foo.txt", null, null, "TAG1", "foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "tags/TAG1/bar/foo.txt", null, null, "TAG1", "bar/foo.txt");
    }

    private SvnLogicalPathMatcher createOneLevelMatcher() {
        SvnLogicalPathMatcher m = new SvnLogicalPathMatcher();
        m.addTrunkRule(new SvnPathRule(Pattern.compile("trunk(/|$)"), "trunk", ""));
        m.addBranchRule(new SvnPathRule(Pattern.compile("branches/([^/]+)"), "${1}", ""));
        m.addTagRule(new SvnPathRule(Pattern.compile("tags/([^/]+)"), "${1}", ""));
        return m;
    }

    @Test
    public void testEmptyMatcher() {
        SvnLogicalPathMatcher m = new SvnLogicalPathMatcher();
        m.addTrunkRule(new SvnPathRule(Pattern.compile(""), "trunk", ""));
        SvnLogicalPathMatcherTest.assertMatch(m, "test", null, null, null, null);
    }

    @Test
    public void testMultiLevelScheme() {
        SvnLogicalPathMatcher m = this.createMultiLevelMatcher();
        SvnLogicalPathMatcherTest.assertMatch(m, "foo.txt", null, null, null, null);
        SvnLogicalPathMatcherTest.assertMatch(m, "trunk/foo.txt", null, null, null, null);
        SvnLogicalPathMatcherTest.assertMatch(m, "branches/foo.txt", null, null, null, null);
        SvnLogicalPathMatcherTest.assertMatch(m, "tagsfoo.txt", null, null, null, null);
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/trunk/foo.txt", "trunk", null, null, "PRJ1/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/trunk/bar/foo.txt", "trunk", null, null, "PRJ1/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/trunk/foo.txt", "trunk", null, null, "PRJ2/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/trunk/bar/foo.txt", "trunk", null, null, "PRJ2/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/branches/BR123/foo.txt", null, "PRJ1-BR123", null, "PRJ1/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/branches/BR123/bar/foo.txt", null, "PRJ1-BR123", null, "PRJ1/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/branches/BR123/foo.txt", null, "PRJ2-BR123", null, "PRJ2/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/branches/BR123/bar/foo.txt", null, "PRJ2-BR123", null, "PRJ2/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/tags/TAG1/foo.txt", null, null, "PRJ1-TAG1", "PRJ1/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/tags/TAG1/bar/foo.txt", null, null, "PRJ1-TAG1", "PRJ1/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/tags/TAG1/foo.txt", null, null, "PRJ2-TAG1", "PRJ2/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/tags/TAG1/bar/foo.txt", null, null, "PRJ2-TAG1", "PRJ2/bar/foo.txt");
    }

    private SvnLogicalPathMatcher createMultiLevelMatcher() {
        SvnLogicalPathMatcher m = new SvnLogicalPathMatcher();
        m.addTrunkRule(new SvnPathRule(Pattern.compile("([^/]+)/trunk/"), "trunk", "${1}"));
        m.addBranchRule(new SvnPathRule(Pattern.compile("([^/]+)/branches/([^/]+)"), "${1}-${2}", "${1}"));
        m.addTagRule(new SvnPathRule(Pattern.compile("([^/]+)/tags/([^/]+)"), "${1}-${2}", "${1}"));
        return m;
    }

    @Test
    public void testContainerIdentification() {
        SvnLogicalPathMatcher m = this.createOneLevelMatcher();
        this.assertContainerMatch(m, "", "root:");
        this.assertContainerMatch(m, "/", "root:");
        this.assertContainerMatch(m, "/test.txt", "root:");
        this.assertContainerMatch(m, "/dir/test.txt", "root:");
        this.assertContainerMatch(m, "/trunk", "trunk:");
        this.assertContainerMatch(m, "/trunk/", "trunk:");
        this.assertContainerMatch(m, "/trunk/test.bat", "trunk:");
        this.assertContainerMatch(m, "/branches", "root:");
        this.assertContainerMatch(m, "/branches/test", "branch:");
        this.assertContainerMatch(m, "/branches/test/test2", "branch:");
        this.assertContainerMatch(m, "/tags", "root:");
        this.assertContainerMatch(m, "/tags/test", "tag:");
        this.assertContainerMatch(m, "/tags/test/test2", "tag:");
    }

    private void assertContainerMatch(SvnLogicalPathMatcher m, String path, String expectedId) {
        String containerId = m.getContainerId(new Path((CharSequence)path));
        Assert.assertTrue((String)("ContainerId for " + path + " incorrect"), (boolean)containerId.startsWith(expectedId));
    }

    private static void assertMatch(SvnLogicalPathMatcher m, String path, String expectedTrunk, String expectedBranch, String expectedTag, String expectedLogical) {
        Assert.assertNotNull((Object)m);
        Path p = new Path((CharSequence)path);
        Assert.assertEquals((String)expectedTrunk, (String)m.getTrunk(p));
        Assert.assertEquals((String)expectedBranch, (String)m.getBranch(p));
        Assert.assertEquals((String)expectedTag, (String)m.getTag(p));
        Path lp = m.getLogicalPath(p);
        if (expectedLogical == null) {
            Assert.assertNull((Object)lp);
        } else {
            Assert.assertNotNull((Object)lp);
            Assert.assertEquals((String)expectedLogical, (String)lp.toString());
        }
    }

    @Test
    public void testNoRules() {
        SvnLogicalPathMatcher matcher = new SvnLogicalPathMatcher();
        SvnLogicalPathMatcherTest.assertMatch(matcher, "/", null, null, null, null);
        SvnLogicalPathMatcherTest.assertMatch(matcher, "/trunk", null, null, null, null);
        SvnLogicalPathMatcherTest.assertMatch(matcher, "/trunk/test.txt", null, null, null, null);
        SvnLogicalPathMatcherTest.assertMatch(matcher, "/branches/br1/test.txt", null, null, null, null);
        SvnLogicalPathMatcherTest.assertMatch(matcher, "/tags/tag1/test.txt", null, null, null, null);
    }

    @Test
    public void testCaching() {
        String br2;
        SvnLogicalPathMatcher matcher = this.createOneLevelMatcher();
        String br1 = matcher.getBranch(new Path((CharSequence)"/branches/br1/test.txt"));
        Assert.assertTrue((String)"Caching not working", (br1 == (br2 = matcher.getBranch(new Path((CharSequence)"/branches/br1/test2.txt"))) ? 1 : 0) != 0);
        Path lp1 = matcher.getLogicalPath(new Path((CharSequence)"/branches/br1/test.txt"));
        Path lp2 = matcher.getLogicalPath(new Path((CharSequence)"/branches/br1/test.txt"));
        Assert.assertTrue((String)"Caching not working", (lp1 == lp2 ? 1 : 0) != 0);
    }

    @Test
    public void testTagRoots() {
        SvnLogicalPathMatcher matcher = this.createOneLevelMatcher();
        Path root = matcher.getTagRoot(new Path((CharSequence)"/tags/tag1/test.txt"));
        Assert.assertEquals((String)"get TagRoot failed", (String)"tags/tag1", (String)root.getPath());
        root = matcher.getTagRoot(new Path((CharSequence)"/tags/tag1"));
        Assert.assertEquals((String)"get TagRoot failed", (String)"tags/tag1", (String)root.getPath());
        root = matcher.getTagRoot(new Path((CharSequence)"/branches/br1/test.txt"));
        Assert.assertTrue((String)"get TagRoot failed", (root == null ? 1 : 0) != 0);
    }

    @Test
    public void testIsTagRoot() {
        SvnLogicalPathMatcher matcher = this.createOneLevelMatcher();
        Assert.assertTrue((String)"isTagRoot failed", (boolean)matcher.isTagRoot(new Path((CharSequence)"/tags/tag1")));
        Assert.assertFalse((String)"isTagRoot failed", (boolean)matcher.isTagRoot(new Path((CharSequence)"/tags")));
        Assert.assertFalse((String)"isTagRoot failed", (boolean)matcher.isTagRoot(new Path((CharSequence)"/tags/tag1/foo/bar")));
        Assert.assertFalse((String)"isTagRoot failed", (boolean)matcher.isTagRoot(new Path((CharSequence)"/branches/br1")));
        Assert.assertFalse((String)"isTagRoot failed", (boolean)matcher.isTagRoot(new Path((CharSequence)"/branches/br1/foo/bar")));
    }

    @Test
    public void testMultipleTags() {
        SvnLogicalPathMatcher m = new SvnLogicalPathMatcher();
        m.addTrunkRule(new SvnPathRule(Pattern.compile("trunk(/|)"), "trunk", ""));
        m.addBranchRule(new SvnPathRule(Pattern.compile("branches/([^/]+)"), "${1}", ""));
        m.addTagRule(new SvnPathRule(Pattern.compile("tags/([^/]+)"), "${1}", ""));
        m.addTagRule(new SvnPathRule(Pattern.compile("tags/old/([^/]+)"), "${1}", ""));
        Path p1 = new Path((CharSequence)"tags/blah/path");
        Path p2 = new Path((CharSequence)"tags/old/blah2/path2");
        Assert.assertEquals((String)"Tag match incorrect", (String)"blah", (String)m.getTag(p1));
        Assert.assertEquals((String)"Tag match incorrect", (String)"blah2", (String)m.getTag(p2));
        Assert.assertEquals((String)"tag logical path incorrect", (Object)new Path((CharSequence)"path"), (Object)m.getLogicalPath(p1));
        Assert.assertEquals((String)"tag logical path incorrect", (Object)new Path((CharSequence)"path2"), (Object)m.getLogicalPath(p2));
        Assert.assertEquals((String)"tag root incorrect", (Object)new Path((CharSequence)"tags/blah"), (Object)m.getTagRoot(p1));
        Assert.assertEquals((String)"tag root incorrect", (Object)new Path((CharSequence)"tags/old/blah2"), (Object)m.getTagRoot(p2));
    }

    @Test
    public void testMatcherOfWin() throws ConfigException {
        SvnSymbolicHelper symHelper = new SvnSymbolicHelper();
        symHelper.setAutorules(true);
        SvnLogicalPathMatcher m = new SvnLogicalPathMatcher(symHelper.toXmlBean());
        SvnLogicalPathMatcherTest.assertMatch(m, "foo.txt", null, null, null, null);
        SvnLogicalPathMatcherTest.assertMatch(m, "trunk/foo.txt", "trunk", null, null, "foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "trunk/bar/foo.txt", "trunk", null, null, "bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "branches/BR123/foo.txt", null, "BR123", null, "foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "branches/BR123/bar/foo.txt", null, "BR123", null, "bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "tags/TAG1/foo.txt", null, null, "TAG1", "foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "tags/TAG1/bar/foo.txt", null, null, "TAG1", "bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/trunk/foo.txt", "trunk", null, null, "PRJ1/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/trunk/bar/foo.txt", "trunk", null, null, "PRJ1/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/trunk/foo.txt", "trunk", null, null, "PRJ2/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/trunk/bar/foo.txt", "trunk", null, null, "PRJ2/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/branches/BR123/foo.txt", null, "BR123", null, "PRJ1/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/branches/BR123/bar/foo.txt", null, "BR123", null, "PRJ1/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/branches/BR123/foo.txt", null, "BR123", null, "PRJ2/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/branches/BR123/bar/foo.txt", null, "BR123", null, "PRJ2/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/tags/TAG1/foo.txt", null, null, "TAG1", "PRJ1/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ1/tags/TAG1/bar/foo.txt", null, null, "TAG1", "PRJ1/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/tags/TAG1/foo.txt", null, null, "TAG1", "PRJ2/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "PRJ2/tags/TAG1/bar/foo.txt", null, null, "TAG1", "PRJ2/bar/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassiantrunk/trunk/foo.txt", "trunk", null, null, "atlassiantrunk/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassiantrunk/branches/b1/foo.txt", null, "b1", null, "atlassiantrunk/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassian/tags/trunk/foo.txt", null, null, ":trunk", "atlassian/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassian/tags/branches/b1/foo.txt", null, null, "branches", "atlassian/b1/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassian/crucible/trunk/foo.txt", "trunk", null, null, "atlassian/crucible/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassian/crucible/trunk/dir/foo.txt", "trunk", null, null, "atlassian/crucible/dir/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassian/crucible/branches/iteration03/foo.txt", null, "iteration03", null, "atlassian/crucible/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassian/crucible/branches/iteration03/dir/foo.txt", null, "iteration03", null, "atlassian/crucible/dir/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassian/crucible/tags/build123/foo.txt", null, null, "build123", "atlassian/crucible/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassian/crucible/tags/build123/dir/foo.txt", null, null, "build123", "atlassian/crucible/dir/foo.txt");
        SvnLogicalPathMatcherTest.assertMatch(m, "atlassian/crucible/trunk/lib/tags/foo.tld", "trunk", null, null, "atlassian/crucible/lib/tags/foo.tld");
    }
}

