/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.cenqua.fisheye.svn.SvnLogMessage;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SvnLogMessageTest {
    @Rule
    public CaptureLog4jLogsRule logs = new CaptureLog4jLogsRule();

    @Test
    public void shouldParseFullDate() throws Exception {
        SvnLogMessage msg = this.createMessageWithRevDate("2014-12-16T11:13:41.282096Z");
        Date parsedDate = msg.getDate();
        Assert.assertThat((Object)parsedDate, (Matcher)Matchers.equalTo((Object)new DateTime(2014, 12, 16, 11, 13, 41, 282, DateTimeZone.UTC).toDate()));
    }

    @Test
    public void shouldParseDateWithTruncatedMillis() throws Exception {
        SvnLogMessage msg = this.createMessageWithRevDate("2014-12-16T11:13:41.0Z");
        Date parsedDate = msg.getDate();
        Assert.assertThat((Object)parsedDate, (Matcher)Matchers.equalTo((Object)new DateTime(2014, 12, 16, 11, 13, 41, 0, DateTimeZone.UTC).toDate()));
    }

    @Test
    public void shouldParseDateWithNoMillis() throws Exception {
        SvnLogMessage msg = this.createMessageWithRevDate("2014-12-16T11:13:41Z");
        Date parsedDate = msg.getDate();
        Assert.assertThat((Object)parsedDate, (Matcher)Matchers.equalTo((Object)new DateTime(2014, 12, 16, 11, 13, 41, 0, DateTimeZone.UTC).toDate()));
    }

    @Test
    public void shouldLogErrorAndReturnNullWithGarbledDate() throws Exception {
        String input = "2014-12-16Tfoobar";
        SvnLogMessage msg = this.createMessageWithRevDate(input);
        Date parsedDate = msg.getDate();
        LoggingEvent logEvent = this.logs.getEvents().get(0);
        String loggedStackTrace = Throwables.getStackTraceAsString((Throwable)logEvent.getThrowableInformation().getThrowable());
        Assert.assertThat((Object)parsedDate, (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)loggedStackTrace, (Matcher)Matchers.containsString((String)input));
    }

    private SvnLogMessage createMessageWithRevDate(String revDate) {
        return new SvnLogMessage(1L, (Map)ImmutableMap.of((Object)"svn:date", (Object)revDate));
    }
}

