/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.SpringIntegrationTestBase;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.svn.SvnExceptionalAncestryTestBase;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import org.junit.Before;
import org.junit.Test;

public class SvnExceptionalAncestryUpgradeTest
extends SpringIntegrationTestBase {
    SvnExceptionalAncestryTestBase testBase = new SvnExceptionalAncestryTestBase();

    protected String getCacheDumpFile() {
        return "test/testfiles/svn/caches/exceptional-2.5.0.zip";
    }

    @Before
    public void setUp() throws Exception {
        AppConfig.setTestMode();
    }

    @Test
    public void testSvnUpgrade() throws Exception {
        SvnTestHarness harness = new SvnTestHarness(){

            @Override
            public void startRepo() {
                SvnExceptionalAncestryUpgradeTest.this.unzipCache(this.getAppDir(), this.getRepoName());
            }
        };
        this.upgradeAndValidateAncestry(harness, "svnupgrade");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeAndValidateAncestry(SvnTestHarness harness, String repoName) throws Exception {
        try {
            AppConfig.getsConfig().initCrossRepLuceneIndex();
            harness.setRepoName(repoName);
            harness.setSymbolicDefinition(this.testBase.getPathMatcher());
            harness.createRepoDir();
            harness.createAndStartEngine();
            try {
                ((Svn2RepositoryEngine)harness.getEngine()).slurp();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.testBase.testAncestry((Svn2Cache)((Svn2RepositoryEngine)harness.getEngine()).getInternalRevisionCache());
        }
        finally {
            harness.cleanUp();
        }
    }

    private void unzipCache(File appDir, String repoName) {
        try {
            File cacheDir = new File(appDir, "var/cache/" + repoName);
            System.out.println("Cache dir: " + cacheDir);
            IOHelper.mkdirs((File)cacheDir);
            String cacheZipName = this.getCacheDumpFile();
            File cacheZip = new File(FisheyeTestEnv.WORKSPACE_DIR, cacheZipName);
            IOHelper.unzip((File)cacheZip, (File)cacheDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

