/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2Cache;
import com.cenqua.fisheye.config1.SvnSymbolicRuleType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.svn.SvnChangeSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import junit.framework.TestCase;

public class SvnExceptionalAncestryTestBase {
    protected SvnSymbolicType getPathMatcher() {
        SvnSymbolicType matcher = SvnSymbolicType.Factory.newInstance();
        SvnSymbolicRuleType trunk = matcher.addNewTrunk();
        trunk.setRegex("trunk(/|)");
        trunk.setName("trunk");
        trunk.setLogical("");
        SvnSymbolicRuleType branch = matcher.addNewBranch();
        branch.setRegex("branches/([^/]+)");
        branch.setName("${1}");
        branch.setLogical("");
        SvnSymbolicRuleType tag = matcher.addNewTag();
        tag.setRegex("tags/([^/]+)");
        tag.setName("${1}");
        tag.setLogical("");
        SvnSymbolicRuleType branch2 = matcher.addNewBranch();
        branch2.setRegex("illogical-branches/([^/]+)");
        branch2.setName("${1}");
        branch2.setLogical("");
        SvnSymbolicRuleType branch3 = matcher.addNewBranch();
        branch3.setRegex("private-branches/([^/]+)");
        branch3.setName("private-${1}");
        branch3.setLogical("");
        return matcher;
    }

    protected void testAncestry(Svn2Cache cache) throws Exception {
        for (Commit commit : Commit.values()) {
            SvnChangeSet cs = cache.getChangeSet(String.valueOf(commit.csId));
            String was = "Was: p=" + cs.getParents() + "; b=" + cs.getBranches() + "; t=" + cs.getTags() + "; tp=" + cs.getTagParents() + "; Expected: p=" + commit.parentIds + "; b=" + commit.branches + "; t=" + commit.tags + "; tp=" + commit.tagParents;
            TestCase.assertEquals((String)(commit.name() + "@" + commit.csId + " does not have expected parents. " + was), commit.parentIds, new TreeSet(cs.getParents()));
            TestCase.assertEquals((String)(commit.name() + "@" + commit.csId + " does not have expected branches. " + was), commit.branches, new TreeSet(cs.getBranches()));
            TestCase.assertEquals((String)(commit.name() + "@" + commit.csId + " does not have expected tags. " + was), commit.tags, new TreeSet(cs.getTags()));
            TestCase.assertEquals((String)(commit.name() + "@" + commit.csId + " does not have expected tagParents. " + was), commit.tagParents, new TreeSet(cs.getTagParents()));
        }
    }

    public static enum Commit {
        INITIAL("1", Collections.EMPTY_LIST, Arrays.asList("root:", "trunk")),
        ON_MULTIPLE_BRANCHES("4", Arrays.asList("2", "3"), Arrays.asList("trunk", "branch1"), Arrays.asList("tag1", "tag2")),
        ON_ROOT("5", Arrays.asList("1"), Arrays.asList("root:")),
        ON_ROOT_AND_TRUNK("6", Arrays.asList("4", "5"), Arrays.asList("root:", "trunk"), Arrays.asList("complex-tag1", "tag3", "tag5")),
        TAG("7", Arrays.asList("6"), Arrays.asList("root:"), (List<String>)Collections.EMPTY_LIST, Arrays.asList("4")),
        MODIFY_TAG("8", Arrays.asList("4"), Arrays.asList("tag:tag1")),
        COMPLEX_BRANCH("9", Arrays.asList("6"), Arrays.asList("complex-branch1"), (List<String>)Collections.EMPTY_LIST, true),
        MODIFY_COMPLEX_TAG("11", Arrays.asList("6"), Arrays.asList("tag:complex-tag1")),
        BRANCH_FROM_TAG("13", Arrays.asList("4"), Arrays.asList("branch2")),
        BRANCH_FROM_MODIFIED_TAG("14", Arrays.asList("8"), Arrays.asList("branch3")),
        ORPHAN_BRANCH("15", Collections.EMPTY_LIST, Arrays.asList("orphan")),
        DELETE_BRANCH("16", Arrays.asList("14"), Arrays.asList("branch3")),
        ILLOGICAL_BRANCH_1("17", Arrays.asList("4"), Arrays.asList("branch1")),
        LOGICAL_BRANCH_1("18", Arrays.asList("17"), Arrays.asList("branch1"), Arrays.asList("tag4", "tag6", "tag7")),
        PRIVATE_BRANCH_1("19", Collections.EMPTY_LIST, Arrays.asList("private-branch1")),
        ILLOGICAL_BRANCH_2("20", Arrays.asList("18"), Arrays.asList("branch1")),
        CREATE_MULTIPLE_TAGS_AND_BRANCHES("21", Arrays.asList("6", "12"), Arrays.asList("root:", "branch4"), (List<String>)Collections.EMPTY_LIST, Arrays.asList("6", "18")),
        CREATE_TWO_TAGS("22", Arrays.asList("21"), Arrays.asList("root:"), (List<String>)Collections.EMPTY_LIST, Arrays.asList("6", "18")),
        MODIFY_TAG_AND_CREATE_NEW_TAG("23", Arrays.asList("6", "22"), Arrays.asList("root:", "tag:tag5"), (List<String>)Collections.EMPTY_LIST, Arrays.asList("18")),
        MERGE_MODIFIED_TAG_TO_TRUNK("24", Arrays.asList("6"), Arrays.asList("trunk"), Arrays.asList("complex-tag2")),
        COMPLEX_TAG_WITH_REPLACE("25", Arrays.asList("23"), Arrays.asList("root:"), (List<String>)Collections.EMPTY_LIST, Arrays.asList("24")),
        MERGE_NEW_FILE_TO_TRUNK("26", Arrays.asList("24", "19"), Arrays.asList("trunk"));

        public final String csId;
        public final TreeSet<String> parentIds;
        public final TreeSet<String> branches;
        public final boolean complex;
        public final TreeSet<String> tags;
        public final TreeSet<String> tagParents;

        private Commit(String csId, List<String> parentIds, List<String> branches, List<String> tags, List<String> tagParents, boolean complex) {
            this.csId = csId;
            this.parentIds = new TreeSet<String>(parentIds);
            this.branches = new TreeSet<String>(branches);
            this.tags = new TreeSet<String>(tags);
            this.tagParents = new TreeSet<String>(tagParents);
            this.complex = complex;
        }

        private Commit(String csId, List<String> parentIds, List<String> branches) {
            this(csId, parentIds, branches, Collections.emptyList(), Collections.emptyList(), false);
        }

        private Commit(String csId, List<String> parentIds, List<String> branches, List<String> tags) {
            this(csId, parentIds, branches, tags, Collections.emptyList(), false);
        }

        private Commit(String csId, List<String> parentIds, List<String> branches, List<String> tags, List<String> tagParents) {
            this(csId, parentIds, branches, tags, tagParents, false);
        }

        private Commit(String csId, List<String> parentIds, List<String> branches, List<String> tags, boolean complex) {
            this(csId, parentIds, branches, tags, Collections.emptyList(), complex);
        }
    }
}

