/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.svn.TestSvnDiffListener;
import com.cenqua.fisheye.svn.diff.SvnDiffListener;
import com.cenqua.fisheye.svn.diff.SvnDiffParser;
import com.cenqua.fisheye.svn.diff.SvnDiffParsingException;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class SvnDiffParserTest {
    private RepositoryStatus status = new RepositoryStatus("test");

    @Test
    public void testDirPropertyAddition() throws Exception {
        TestSvnDiffListener listener = this.parseDiff("dirpropadd.txt");
        TestSvnDiffListener.FileRecord rootRecord = listener.getRecord(Path.ROOT);
        Assert.assertNotNull((String)"Root dir prop add not recorded against root", (Object)rootRecord);
        Assert.assertTrue((String)"Property Change expected", (boolean)rootRecord.isPropertyIndexMarkSeen());
    }

    @Test
    public void testFilePropertyAddition() throws Exception {
        TestSvnDiffListener listener = this.parseDiff("filepropadd.txt");
        Path path = new Path((CharSequence)"trunk/f1.txt");
        TestSvnDiffListener.FileRecord record = listener.getRecord(path);
        Assert.assertNotNull((String)("Change expected for " + path), (Object)record);
        Assert.assertTrue((String)"Property Change expected", (boolean)record.isPropertyIndexMarkSeen());
    }

    @Test
    public void testEmptyPropertyAddition() throws Exception {
        TestSvnDiffListener listener = this.parseDiff("emptypropadd.txt");
        Path path = new Path((CharSequence)"trunk/f1.txt");
        TestSvnDiffListener.FileRecord record = listener.getRecord(path);
        Assert.assertNotNull((String)("Change expected for " + path), (Object)record);
        Assert.assertTrue((String)"Property Change expected", (boolean)record.isPropertyIndexMarkSeen());
    }

    @Test
    public void testEmptyPropertyDeletion() throws Exception {
        TestSvnDiffListener listener = this.parseDiff("emptypropdelete.txt");
        Path path = new Path((CharSequence)"trunk/f1.txt");
        TestSvnDiffListener.FileRecord record = listener.getRecord(path);
        Assert.assertNotNull((String)("Change expected for " + path), (Object)record);
        Assert.assertTrue((String)"Property Change expected", (boolean)record.isPropertyIndexMarkSeen());
    }

    @Test
    public void testFileChange() throws Exception {
        TestSvnDiffListener listener = this.parseDiff("filechange.txt");
        TestSvnDiffListener.FileRecord record = listener.getRecord(new Path((CharSequence)"trunk/f1.txt"));
        Assert.assertFalse((String)"Property Change unexpected", (boolean)record.isPropertyIndexMarkSeen());
    }

    @Test
    public void testMergeDiff() throws Exception {
        TestSvnDiffListener listener = this.parseDiff("mergediff.txt");
        TestSvnDiffListener.FileRecord record = listener.getRecord(Path.ROOT);
        Assert.assertNotNull((String)"Change expected for root dir", (Object)record);
        Assert.assertTrue((String)"Property Change expected", (boolean)record.isPropertyIndexMarkSeen());
    }

    @Test
    public void testFilePropertyChange() throws Exception {
        TestSvnDiffListener listener = this.parseDiff("filepropchange.txt");
        Path path = new Path((CharSequence)"trunk/f1.txt");
        TestSvnDiffListener.FileRecord record = listener.getRecord(path);
        Assert.assertNotNull((String)("Change expected for " + path), (Object)record);
        Assert.assertTrue((String)"Property Change expected", (boolean)record.isPropertyIndexMarkSeen());
    }

    private TestSvnDiffListener parseDiff(String testFile) throws FileNotFoundException, UnsupportedEncodingException, SvnDiffParsingException {
        File testfile = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/svn/diffs/" + testFile);
        FileInputStream fis = new FileInputStream(testfile);
        ReaderLineReader reader = new ReaderLineReader((Reader)new InputStreamReader((InputStream)fis, "UTF-8"));
        SvnDiffParser parser = new SvnDiffParser(Locale.US, this.status);
        TestSvnDiffListener listener = new TestSvnDiffListener();
        parser.process(reader, (SvnDiffListener)listener);
        return listener;
    }
}

