/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.svn.SvnClientFactory;
import com.cenqua.fisheye.svn.SvnPasswordSupplier;
import com.cenqua.fisheye.svn.util.SvnLoaderConfiguration;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SvnClientFactoryTest {
    @Mock
    SvnPasswordSupplier passwordSupplier;

    @Test
    public void testGetPromptCallback_handlesSvnSshForSvnkitOnly() throws Exception {
        this.testPromptAskYesNoResult(true, true);
        this.testPromptAskYesNoResult(false, false);
    }

    private void testPromptAskYesNoResult(boolean isSvnkit, boolean expectedAnswer) {
        SvnLoaderConfiguration configuration = (SvnLoaderConfiguration)Mockito.mock(SvnLoaderConfiguration.class);
        Mockito.when((Object)configuration.isSvnkit()).thenReturn((Object)isSvnkit);
        SvnClientFactory svnClientFactory = new SvnClientFactory(this.passwordSupplier, "/", configuration);
        UserPasswordCallback promptCallback = svnClientFactory.getPromptCallback();
        boolean answer = promptCallback.askYesNo("realm", "question", false);
        Assert.assertThat((Object)answer, (Matcher)Matchers.is((Object)expectedAnswer));
    }
}

