/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fecru.util.DebugLogsRule;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.cenqua.fisheye.svn.util.SvnSymbolics;
import com.cenqua.fisheye.svn.util.SvnTestHarnessRule;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class StartRevNoInitialImportTest {
    public static final File DUMP_FILE = new File("test/testfiles/svn/dumps/startrevision.dump");
    public static final int HEAD = 13;
    @Rule
    public DebugLogsRule debugLogsRule = new DebugLogsRule();
    @Rule
    public SvnTestHarnessRule repoResource = new SvnTestHarnessRule();
    private SvnTestHarness.SvnBuilder testHarnessBuilder = SvnTestHarness.builder();

    @Before
    public void setUp() throws Exception {
        this.testHarnessBuilder.setSymbolicDefinition(SvnSymbolics.defaultRules()).setStartRev(13L).setDoInitialImport(false).setDumpFile(DUMP_FILE);
    }

    @Test
    public void testLastRevWithPathContainsOnlyAddedFilesAfter() throws Exception {
        this.testHarnessBuilder.setSubPath("lateproject");
        Svn2Cache svnCache = this.repoResource.slurp(this.testHarnessBuilder);
        List<String> repositoryPaths = this.listRepositoryPaths(svnCache);
        Assert.assertThat(repositoryPaths, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"another-file@13"}));
    }

    @Test
    public void testLastRevWithoutPathContainsOnlyAddedFilesAfter() throws Exception {
        Svn2Cache svnCache = this.repoResource.slurp(this.testHarnessBuilder);
        List<String> repositoryPaths = this.listRepositoryPaths(svnCache);
        Assert.assertThat(repositoryPaths, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"lateproject@13", "lateproject/another-file@13"}));
    }

    @Test
    public void testLateProjCreationWithPathContainsOnlyAddedFilesAfter() throws Exception {
        this.testHarnessBuilder.setStartRev(11L);
        this.testHarnessBuilder.setSubPath("lateproject");
        Svn2Cache svnCache = this.repoResource.slurp(this.testHarnessBuilder);
        List<String> repositoryPaths = this.listRepositoryPaths(svnCache);
        Assert.assertThat(repositoryPaths, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"myfile@12", "another-file@13"}));
    }

    private List<String> listRepositoryPaths(Svn2Cache svnCache) {
        ArrayList paths = Lists.newArrayList();
        svnCache.getFileRevisionDAO().visitDirectoryTree(Path.ROOT, 13L, (pathId, changesetid) -> {
            Path path = svnCache.getFileRevisionDAO().getPath(pathId);
            if (!Path.ROOT.equals((Object)path)) {
                paths.add(String.format("%s@%d", path, changesetid));
            }
        });
        return paths;
    }
}

