/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StartRevNoImportTest
extends SvnTestBase {
    public static final int START_REV = 7;

    @Override
    protected String getDumpFile() {
        return "basic.dump";
    }

    @Override
    protected long getStartRev() {
        return 7L;
    }

    @Override
    protected boolean getDoInitialImport() {
        return false;
    }

    @Test
    public void testPathsInOlderRevisionNotImported() throws Exception {
        SvnRevInfoDAO fileRevisionDAO = this.cache.getFileRevisionDAO();
        ArrayList pathsInRepo = new ArrayList();
        fileRevisionDAO.visitDirectoryTree(Path.ROOT, 8L, (pathId, changesetid) -> {
            Path path = fileRevisionDAO.getPath(pathId);
            pathsInRepo.add(path);
        });
        Assert.assertThat(pathsInRepo, (Matcher)Matchers.containsInAnyOrder((Object[])new Path[]{Path.ROOT, new Path((CharSequence)"branches"), new Path((CharSequence)"branches/br1"), new Path((CharSequence)"branches/br1/test.txt"), new Path((CharSequence)"trunk"), new Path((CharSequence)"trunk/test.txt")}));
        Assert.assertThat((Object)Iterables.transform((Iterable)this.cache.getChangeSet("7").getFileRevisions(), (Function)FileRevision.TO_PATH), (Matcher)Matchers.containsInAnyOrder((Object[])new Path[]{Path.ROOT, new Path((CharSequence)"branches"), new Path((CharSequence)"branches/br1"), new Path((CharSequence)"branches/br1/test.txt")}));
        Assert.assertThat((Object)Iterables.transform((Iterable)this.cache.getChangeSet("8").getFileRevisions(), (Function)FileRevision.TO_PATH), (Matcher)Matchers.containsInAnyOrder((Object[])new Path[]{new Path((CharSequence)"trunk"), new Path((CharSequence)"trunk/test.txt")}));
        Assert.assertThat((Object)this.cache.getFileRevision(new RevInfoKey(new Path((CharSequence)"branches/br1/test.txt"), "7")), this.hasLineCounts(4, 4, 0));
        Assert.assertThat((Object)this.cache.getFileRevision(new RevInfoKey(new Path((CharSequence)"trunk/test.txt"), "8")), this.hasLineCounts(4, 4, 0));
    }

    private Matcher<FileRevision> hasLineCounts(int lineCount, int linesAdded, int linesRemoved) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"lineCount", (Matcher)Matchers.is((Object)lineCount)), (Matcher)Matchers.hasProperty((String)"linesAdded", (Matcher)Matchers.is((Object)linesAdded)), (Matcher)Matchers.hasProperty((String)"linesRemoved", (Matcher)Matchers.is((Object)linesRemoved)));
    }
}

