/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fecru.util.DebugLogsRule;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.cenqua.fisheye.svn.util.SvnSymbolics;
import com.cenqua.fisheye.svn.util.SvnTestHarnessRule;
import com.google.common.collect.Iterators;
import java.io.File;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class StartRevInitialImportTest {
    public static final File DUMP_FILE = new File("test/testfiles/svn/dumps/startrevision.dump");
    public static final int TEST_TIMEOUT_MS = 30000;
    protected Svn2Cache cache;
    @Rule
    public DebugLogsRule debugLogsRule = new DebugLogsRule();
    @Rule
    public SvnTestHarnessRule testHarnessRule = new SvnTestHarnessRule();
    private SvnTestHarness.SvnBuilder testHarnessBuilder = SvnTestHarness.builder();

    @Before
    public void setUp() throws Exception {
        ((SvnTestHarness.SvnBuilder)this.testHarnessBuilder.setSymbolicDefinition(SvnSymbolics.defaultRules()).setDoInitialImport(true).setBlockSize(2L)).setDumpFile(DUMP_FILE);
    }

    @Test(timeout=30000L)
    public void testBranchBRev1() throws Exception {
        this.cache = this.testHarnessRule.slurp(((SvnTestHarness.SvnBuilder)this.testHarnessBuilder.setSubPath("branchB")).setStartRev(1L));
        this.assertNoFakeCommit("1");
    }

    @Test(timeout=30000L)
    public void testBranchBRev3() throws Exception {
        this.cache = this.testHarnessRule.slurp(((SvnTestHarness.SvnBuilder)this.testHarnessBuilder.setSubPath("branchB")).setStartRev(3L));
        this.assertFakeCommit("2");
    }

    @Test(timeout=30000L)
    public void testBranchBRev11() throws Exception {
        this.cache = this.testHarnessRule.slurp(((SvnTestHarness.SvnBuilder)this.testHarnessBuilder.setSubPath("branchB")).setStartRev(11L));
        this.assertNoFakeCommit(null);
    }

    @Test(timeout=30000L)
    public void testLateprojectRev1() throws Exception {
        this.cache = this.testHarnessRule.slurp(((SvnTestHarness.SvnBuilder)this.testHarnessBuilder.setSubPath("lateproject")).setStartRev(11L));
        this.assertNoFakeCommit("11");
    }

    @Test(timeout=30000L)
    public void testLateprojectRev3() throws Exception {
        this.cache = this.testHarnessRule.slurp(((SvnTestHarness.SvnBuilder)this.testHarnessBuilder.setSubPath("lateproject")).setStartRev(3L));
        this.assertNoFakeCommit("11");
    }

    @Test(timeout=30000L)
    public void testLateprojectRev11() throws Exception {
        this.cache = this.testHarnessRule.slurp(((SvnTestHarness.SvnBuilder)this.testHarnessBuilder.setSubPath("lateproject")).setStartRev(11L));
        this.assertNoFakeCommit("11");
    }

    @Test(timeout=30000L)
    public void testLateprojectRev12() throws Exception {
        this.cache = this.testHarnessRule.slurp(((SvnTestHarness.SvnBuilder)this.testHarnessBuilder.setSubPath("lateproject")).setStartRev(12L));
        this.assertFakeCommit("11");
    }

    @Test(timeout=30000L)
    public void testRootRev11() throws Exception {
        this.cache = this.testHarnessRule.slurp(((SvnTestHarness.SvnBuilder)this.testHarnessBuilder.setSubPath(null)).setStartRev(11L));
        this.assertFakeCommit("10");
    }

    @Test(timeout=30000L)
    public void testRootRev1() throws Exception {
        this.cache = this.testHarnessRule.slurp(((SvnTestHarness.SvnBuilder)this.testHarnessBuilder.setSubPath(null)).setStartRev(1L));
        this.assertNoFakeCommit("1");
    }

    private void assertNoFakeCommit(String expectedFirstChangesetId) {
        SvnChangeSet firstChangeSet = (SvnChangeSet)Iterators.getNext((Iterator)this.cache.getChangeSets().iterator(), null);
        MatcherAssert.assertThat((Object)firstChangeSet, (Matcher)Matchers.anyOf((Matcher)Matchers.nullValue(), (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"id", (Matcher)Matchers.is((Object)expectedFirstChangesetId)), (Matcher)Matchers.not((Matcher)Matchers.hasProperty((String)"comment", (Matcher)Matchers.is((Object)"Created by FishEye for initial repository import"))))));
    }

    private void assertFakeCommit(String expectedFirstFakeChangesetId) {
        SvnChangeSet firstChangeSet = (SvnChangeSet)Iterators.getNext((Iterator)this.cache.getChangeSets().iterator(), null);
        MatcherAssert.assertThat((Object)firstChangeSet, (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"id", (Matcher)Matchers.is((Object)expectedFirstFakeChangesetId)), (Matcher)Matchers.hasProperty((String)"comment", (Matcher)Matchers.is((Object)"Created by FishEye for initial repository import"))));
    }
}

