/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import org.junit.Assert;
import org.junit.Test;

public class RevisionResolutionTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "revresolution";
    }

    @Test
    public void testHeadResolution() throws Exception {
        Path path = new Path((CharSequence)"trunk/f1.txt");
        FileRevision revisionHead = this.cache.findFileRevision(path, "HEAD");
        Assert.assertNotNull((String)"Did not find HEAD revision", (Object)revisionHead.getRevision());
        FileRevision revisionTrunk = this.cache.findFileRevision(path, "trunk");
        Assert.assertEquals((String)"HEAD revision not equal to trunk revision", (Object)revisionTrunk.getRevision(), (Object)revisionHead.getRevision());
    }

    @Test
    public void testNumericResolution() throws Exception {
        Path path = new Path((CharSequence)"trunk/f1.txt");
        FileRevision revision = this.cache.findFileRevision(path, "2");
        Assert.assertEquals((String)"Did not find trunk revision", (Object)"2", (Object)revision.getRevision());
        Assert.assertEquals((String)"Did not find revision on trunk", (Object)path, (Object)revision.getPath());
        revision = this.cache.findFileRevision(path, "5");
        Assert.assertEquals((String)"Did not find branch revision", (Object)"5", (Object)revision.getRevision());
        Assert.assertEquals((String)"Did not find revision on branch", (Object)new Path((CharSequence)"branches/b1/f1.txt"), (Object)revision.getPath());
        revision = this.cache.findFileRevision(path, "9");
        Assert.assertEquals((String)"Did not find branch revision", (Object)"9", (Object)revision.getRevision());
        Assert.assertEquals((String)"Did not find revision on branch", (Object)new Path((CharSequence)"branches/b1a/f1.txt"), (Object)revision.getPath());
    }

    @Test
    public void testSymbolicResolution() throws Exception {
        Path path = new Path((CharSequence)"trunk/f1.txt");
        FileRevision revision = this.cache.findFileRevision(path, "trunk");
        Assert.assertEquals((String)"Did not find trunk revision", (Object)"3", (Object)revision.getRevision());
        Assert.assertEquals((String)"Did not find revision on trunk", (Object)path, (Object)revision.getPath());
    }

    @Test
    public void testJunkResolution() throws Exception {
        Path path = new Path((CharSequence)"trunk/f1.txt");
        FileRevision revision = this.cache.findFileRevision(path, "2x");
        Assert.assertNull((String)"Should not have found a revision", (Object)revision);
        revision = this.cache.findFileRevision(path, "unused");
        Assert.assertNull((String)"Should not have found a revision", (Object)revision);
    }
}

