/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.SpringIntegrationTestBase;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2Scanner;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.xmlbeans.XmlException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class RepositoryScanTest
extends SpringIntegrationTestBase {
    private SvnTestHarness testHarness;

    @Before
    public void setUp() throws Exception {
        this.testHarness = new SvnTestHarness();
    }

    @After
    public void tearDown() throws Exception {
        this.testHarness.cleanUp();
    }

    @Test
    public void testAllDumps() throws IOException, RepositoryClientException, DbException, ConfigException, XmlException {
        File[] files;
        File testDir = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/svn/testdumps");
        for (File file : files = testDir.listFiles()) {
            if (!file.isFile()) continue;
            this.testHarness.slurpDump(file);
            this.testHarness.assertNoSlurpErrors(file.getAbsolutePath());
            this.testDirInfo((Svn2Cache)((Svn2Scanner)this.testHarness.getScanner()).getCache());
            this.testHarness.cleanUp();
        }
    }

    private void testDirInfo(Svn2Cache cache) {
        try {
            cache.findDirInfo(Path.ROOT);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Exception getting Dir Info: " + e.getClass() + " - " + e.getMessage()));
        }
    }
}

