/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.subversion.javahl.ClientException;
import org.junit.Test;

public class ReplaceTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/replace.dump";
    }

    @Test
    public void testPlainReplace() throws IOException, ClientException, DbException {
        FileHistory history = this.cache.getFileHistory(new Path((CharSequence)"/trunk/test.txt"));
        FileRevision rev = history.getRevision(history.getHead());
        Assert.assertNotNull((String)"Rev not found", (Object)rev);
        Assert.assertEquals((String)"Head change set id incorrect", (String)"7", (String)rev.getChangeSetId());
        rev = history.getRevision("5");
        Assert.assertEquals((String)"Replace line count not correct", (int)6, (int)rev.getLineCount());
        Assert.assertEquals((String)"Replace lines added not correct", (int)6, (int)rev.getLinesAdded());
        Assert.assertEquals((String)"Replace lines removed not correct", (int)2, (int)rev.getLinesRemoved());
        rev = history.getRevision("7");
        Assert.assertEquals((String)"Replace line count not correct", (int)9, (int)rev.getLineCount());
        Assert.assertEquals((String)"Replace lines added not correct", (int)9, (int)rev.getLinesAdded());
        Assert.assertEquals((String)"Replace lines removed not correct", (int)6, (int)rev.getLinesRemoved());
    }

    @Test
    public void testBranchReplace() throws DbException {
        FileHistory history = this.cache.getFileHistory(new Path((CharSequence)"/branches/br2/test.txt"));
        FileRevision rev = history.getRevision("6");
        Assert.assertTrue((String)"Branch Replace action not correct", (boolean)rev.isAdded());
        Assert.assertEquals((String)"Branch Replace line count not correct", (int)2, (int)rev.getLineCount());
        Assert.assertEquals((String)"Branch Replace lines added not correct", (int)2, (int)rev.getLinesAdded());
        Assert.assertEquals((String)"Branch Replace lines removed not correct", (int)0, (int)rev.getLinesRemoved());
    }
}

