/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import junit.framework.Assert;
import org.junit.Test;

public class ReplaceDirTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/replacedir.dump";
    }

    @Test
    public void testDirReplace() throws Exception {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"trunk/src/dir1/test1.txt"), "6");
        FileRevision rev = this.cache.getFileRevision(key);
        Assert.assertFalse((String)"Should not be deleted", (boolean)rev.isDead());
        Assert.assertTrue((String)"Should be a file", (boolean)rev.isFile());
        Assert.assertEquals((String)"Linecount incorrect", (int)3, (int)rev.getLineCount());
        key = new RevInfoKey(new Path((CharSequence)"trunk/src/dir1/test2.txt"), "6");
        rev = this.cache.getFileRevision(key);
        Assert.assertTrue((String)"File revision not found", (rev != null && rev.isDead() ? 1 : 0) != 0);
        key = new RevInfoKey(new Path((CharSequence)"trunk/src/dir1/testa.txt"), "6");
        rev = this.cache.getFileRevision(key);
        Assert.assertFalse((boolean)rev.isDead());
        Assert.assertTrue((boolean)rev.isAdded());
        Assert.assertEquals((String)"Linecount incorrect", (int)1, (int)rev.getLineCount());
        key = new RevInfoKey(new Path((CharSequence)"trunk/src/dir2/test3.txt"), "6");
        rev = this.cache.getFileRevision(key);
        Assert.assertFalse((boolean)rev.isDead());
        Assert.assertEquals((String)"Linecount incorrect", (int)3, (int)rev.getLineCount());
        key = new RevInfoKey(new Path((CharSequence)"trunk/src/dir2/test4.txt"), "6");
        rev = this.cache.getFileRevision(key);
        Assert.assertTrue((boolean)rev.isDead());
        key = new RevInfoKey(new Path((CharSequence)"trunk/src/dir2/testb.txt"), "6");
        rev = this.cache.getFileRevision(key);
        Assert.assertFalse((boolean)rev.isDead());
        Assert.assertTrue((boolean)rev.isAdded());
        Assert.assertEquals((String)"Linecount incorrect", (int)1, (int)rev.getLineCount());
    }
}

