/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.BlameChunkMatcher;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.io.IOException;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class RenameBlameTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/renameblame.dump";
    }

    @Test
    public void testRenameWithModificationBlameFallback() throws DbException, IOException {
        Blame blame = this.cache.getBlameFallback(new RevInfoKey(new Path((CharSequence)"branches/branch-x/d.txt"), "7"));
        Assert.assertThat((Object)blame.getChunks(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.blameChunk(0, 1, "2"), this.blameChunk(1, 2, "4"), this.blameChunk(2, 3, "5"), this.blameChunk(3, 4, "7")}));
    }

    @Test
    public void testRenameThenModificationBlameFallback() throws DbException, IOException {
        Blame blame = this.cache.getBlameFallback(new RevInfoKey(new Path((CharSequence)"trunk/b.txt"), "4"));
        Assert.assertThat((Object)blame.getChunks(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.blameChunk(0, 1, "2"), this.blameChunk(1, 2, "4")}));
    }

    @Test
    public void testRenameThenModificationBlame() throws DbException, IOException {
        Optional blame = this.cache.getBlame(new RevInfoKey(new Path((CharSequence)"trunk/b.txt"), "4"), false);
        Assert.assertThat((String)"blame is present", (Object)blame.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((Blame)blame.get()).getChunks(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.blameChunk(0, 1, "2"), this.blameChunk(1, 2, "4")}));
    }

    private Matcher<BlameChunk> blameChunk(int start, int end, String revision) {
        return new BlameChunkMatcher(start, end).withRevId((Matcher<Integer>)Matchers.not((Object)-1)).withRevision(revision);
    }
}

